/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.util.EcoreEqualityHelper;

public class GraphEqualityHelper
extends HashMap<EObject, EObject> {
    private static final long serialVersionUID = 1L;
    private EcoreEqualityHelper attributeHelper;
    private EObject[][] t1;
    private EObject[][] t2;
    private int current;
    private Model m1;
    private Model m2;
    private boolean ignoreNodeIDs;

    public GraphEqualityHelper(boolean ignoreNodeIDs, boolean ignoreAttributes) {
        this.ignoreNodeIDs = ignoreNodeIDs;
        this.attributeHelper = new EcoreEqualityHelper(ignoreNodeIDs, ignoreAttributes);
    }

    public boolean equals(Model model1, Model model2) {
        this.m1 = model1;
        this.m2 = model2;
        this.t1 = new EObject[][]{(EObject[])this.m1.getResource().getContents().toArray((Object[])new EObject[0])};
        this.t2 = new EObject[][]{(EObject[])this.m2.getResource().getContents().toArray((Object[])new EObject[0])};
        this.current = 0;
        boolean equals = this.depthFirst();
        this.m1 = null;
        this.m2 = null;
        this.t1 = null;
        this.t2 = null;
        return equals;
    }

    private boolean depthFirst() {
        if (this.current < 0) {
            return false;
        }
        EObject[] l1 = this.t1[this.current];
        EObject[] l2 = this.t1[this.current];
        if (l1.length != l2.length) {
            return false;
        }
        int index1 = -1;
        int i = 0;
        while (i < l1.length) {
            if (l1[i] != null) {
                index1 = i;
                break;
            }
            ++i;
        }
        if (index1 < 0) {
            if (this.current == 0) {
                return true;
            }
            --this.current;
            return this.depthFirst();
        }
        EObject node1 = l1[index1];
        EObject node2 = (EObject)this.get(node1);
        if (node2 != null) {
            int index2 = -1;
            int i2 = 0;
            while (i2 < l2.length) {
                if (l2[i2] == node2) {
                    index2 = i2;
                    break;
                }
                ++i2;
            }
            if (index2 >= 0) {
                l1[index1] = null;
                l2[index2] = null;
                if (this.depthFirst()) {
                    return true;
                }
                l1[index1] = node1;
                l2[index2] = node2;
            }
            return false;
        }
        EClass eclass = node1.eClass();
        int index2 = 0;
        while (index2 < l2.length) {
            node2 = l2[index2];
            if (node2 != null && eclass.equals(node2.eClass()) && (this.ignoreNodeIDs || this.getNodeID(node1) == this.getNodeID(node2))) {
                this.put(node1, node2);
                boolean valid = true;
                for (EStructuralFeature feature : eclass.getEAllStructuralFeatures()) {
                    if (feature instanceof EAttribute) {
                        if (!this.attributeHelper.haveEqualAttribute(node1, node2, (EAttribute)feature)) {
                            valid = false;
                        }
                    } else {
                        EObject[] n2;
                        EObject[] n1;
                        if (feature.isMany()) {
                            n1 = ((List)node1.eGet(feature)).toArray(new EObject[0]);
                            n2 = ((List)node2.eGet(feature)).toArray(new EObject[0]);
                        } else {
                            n1 = new EObject[]{(EObject)node1.eGet(feature)};
                            n2 = new EObject[]{(EObject)node2.eGet(feature)};
                            if (n1[0] == null && n2[0] != null || n1[0] != null && n2[0] == null) {
                                valid = false;
                            }
                        }
                        if (valid) {
                            this.t1 = GraphEqualityHelper.grow(this.t1, this.current + 2);
                            this.t2 = GraphEqualityHelper.grow(this.t2, this.current + 2);
                            this.t1[this.current + 1] = n1;
                            this.t2[this.current + 1] = n2;
                            ++this.current;
                            valid = this.depthFirst();
                        }
                    }
                    if (!valid) break;
                }
                if (valid) {
                    l1[index1] = null;
                    l2[index2] = null;
                    if (this.depthFirst()) {
                        return true;
                    }
                    l1[index1] = node1;
                    l2[index2] = node2;
                }
                this.remove(node1);
            }
            ++index2;
        }
        return false;
    }

    private int getNodeID(EObject object) {
        Integer result = (Integer)this.m1.getNodeIDsMap().get((Object)object);
        if (result == null) {
            result = (Integer)this.m2.getNodeIDsMap().get((Object)object);
        }
        if (result == null) {
            throw new RuntimeException("No node ID found for " + object);
        }
        return result;
    }

    private static EObject[][] grow(EObject[][] array, int size) {
        if (size <= array.length) {
            return array;
        }
        EObject[][] result = new EObject[size * 2 + 1][];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }
}

