/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.actions.AbstractStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenStateModelAction
extends AbstractStateSpaceAction {
    private List<State> states = new ArrayList<State>();

    public void run(IAction action) {
        for (State state : this.states) {
            Model model = null;
            try {
                model = this.getExplorer().getStateSpaceManager().getModel(state);
            }
            catch (StateSpaceException e) {
                StateSpaceExplorerPlugin.getInstance().logError("Error retrieving state model", e);
                continue;
            }
            URI base = state.eResource().getURI();
            IFile file = null;
            if (state.isInitial()) {
                URI resolved = model.getResource().getURI().resolve(base);
                Path path = new Path(resolved.toPlatformString(true));
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            } else {
                String name = base.trimFileExtension().lastSegment();
                URI target = base.trimSegments(1).appendSegment(String.valueOf(name) + "_state" + state.getIndex() + ".xmi");
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = resourceSet.createResource(target);
                    resource.getContents().addAll(EcoreUtil.copyAll((Collection)model.getResource().getContents()));
                    resource.save(null);
                    Path path = new Path(target.toPlatformString(true));
                    IContainer folder = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getParent();
                    folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                }
                catch (Throwable t) {
                    StateSpaceExplorerPlugin.getInstance().logError("Error saving state resource", t);
                }
            }
            try {
                if (file == null) continue;
                IWorkbenchPage page = this.getExplorer().getSite().getPage();
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        this.states.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object[] objectArray = structured.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                if (selected instanceof StateEditPart) {
                    State state = ((StateEditPart)((Object)selected)).getState();
                    this.states.add(state);
                }
                ++n2;
            }
        }
        action.setEnabled(!this.states.isEmpty());
    }
}

