/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.commands;

import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.gef.commands.Command;

public abstract class AbstractStateSpaceCommand
extends Command {
    private StateSpaceManager manager;
    private Throwable exception;

    public AbstractStateSpaceCommand(String label, StateSpaceManager manager) {
        super(label);
        this.manager = manager;
    }

    protected StateSpaceManager getStateSpaceManager() {
        return this.manager;
    }

    public void doExecute() throws StateSpaceException {
        this.doRedo();
    }

    public void doUndo() throws StateSpaceException {
    }

    public void doRedo() throws StateSpaceException {
    }

    public final void execute() {
        try {
            this.doExecute();
        }
        catch (Throwable e) {
            StateSpaceExplorerPlugin.getInstance().logError("Error while trying to " + this.getLabel(), e);
            this.exception = e;
        }
    }

    public final void undo() {
        try {
            this.doUndo();
        }
        catch (Throwable e) {
            StateSpaceExplorerPlugin.getInstance().logError("Error while trying to " + this.getLabel(), e);
            this.exception = e;
        }
    }

    public final void redo() {
        try {
            this.doRedo();
        }
        catch (Throwable e) {
            StateSpaceExplorerPlugin.getInstance().logError("Error while trying to " + this.getLabel(), e);
            this.exception = e;
        }
    }

    public Throwable getException() {
        return this.exception;
    }
}

