/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSpringLayouter;
import org.eclipse.swt.widgets.Display;

public class LayoutStateSpaceJob
extends Job {
    private StateSpaceSpringLayouter layouter;
    private StateSpace stateSpace;

    public LayoutStateSpaceJob(StateSpace stateSpace) {
        super("Layouting state space");
        this.setPriority(30);
        this.stateSpace = stateSpace;
        this.layouter = new StateSpaceSpringLayouter();
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.layouter.setStateSpace(this.stateSpace);
        while (!monitor.isCanceled()) {
            try {
                this.layouter.update();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return new Status(4, "org.eclipse.emf.henshin.statespace.explorer", 0, "Error layouting state space", t);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        LayoutStateSpaceJob.this.layouter.commit();
                    }
                    catch (Throwable throwable) {}
                }
            });
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return new Status(0, "org.eclipse.emf.henshin.statespace.explorer", 0, null, null);
    }

    public StateSpaceSpringLayouter getLayouter() {
        return this.layouter;
    }
}

