/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.actions;

import java.util.List;
import org.eclipse.emf.henshin.diagram.edit.actions.AbstractActionHelper;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionElementFinder;
import org.eclipse.emf.henshin.diagram.edit.maps.MapEditor;
import org.eclipse.emf.henshin.diagram.edit.maps.NodeMapEditor;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class NodeActionHelper
extends AbstractActionHelper<Node, Rule> {
    public static final NodeActionHelper INSTANCE = new NodeActionHelper();

    @Override
    public List<Node> getActionElements(Rule rule, Action action) {
        List candidates = ActionElementFinder.getRuleElementCandidates(rule, action, HenshinPackage.eINSTANCE.getGraph_Nodes());
        return this.filterElementsByAction(candidates, action);
    }

    @Override
    protected MapEditor<Node> getMapEditor(Graph target) {
        return new NodeMapEditor(target);
    }

    @Override
    protected MapEditor<Node> getMapEditor(Graph source, Graph target, List<Mapping> mappings) {
        return new NodeMapEditor(source, target, mappings);
    }

    public Node getActionNode(Node node) {
        return ActionElementFinder.getActionElement(node, INSTANCE);
    }

    public Node getLhsNode(Node node) {
        Graph lhs = node.getGraph().getContainerRule().getLhs();
        if (node.getGraph() == lhs) {
            return node;
        }
        Node opposite = this.getActionNode(node);
        if (opposite.getGraph() == lhs) {
            return opposite;
        }
        return null;
    }
}

