/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.presentation.HenshinIcons;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class HenshinPaletteUpdater {
    private static ImageDescriptor EPACKAGE_ICON = ImageDescriptor.createFromImage((Image)HenshinIcons.EPACKAGE);
    private static ImageDescriptor ECLASS_ICON = ImageDescriptor.createFromImage((Image)HenshinIcons.ECLASS);
    private PaletteRoot palette;
    private TransformationSystem system;
    private HashMap<EPackage, PaletteDrawer> drawers;
    private Adapter listener = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            int featureID = event.getFeatureID(TransformationSystem.class);
            if (featureID == 3) {
                HenshinPaletteUpdater.this.refresh();
            }
        }
    };
    private Comparator<EClassifier> eclassComparator = new Comparator<EClassifier>(){

        @Override
        public int compare(EClassifier c1, EClassifier c2) {
            String n1 = c1.getName() != null ? c1.getName() : "";
            String n2 = c2.getName() != null ? c2.getName() : "";
            return n1.compareTo(n2);
        }
    };

    public HenshinPaletteUpdater(PaletteRoot palette, TransformationSystem system) {
        this.palette = palette;
        this.system = system;
        this.drawers = new HashMap();
        system.eAdapters().add((Object)this.listener);
        this.refresh();
    }

    public void refresh() {
        for (PaletteDrawer drawer : this.drawers.values()) {
            this.palette.remove((PaletteEntry)drawer);
        }
        this.drawers.clear();
        for (EPackage epackage : this.system.getImports()) {
            PaletteDrawer drawer = new PaletteDrawer(epackage.getName(), EPACKAGE_ICON);
            ArrayList eclassifiers = new ArrayList(epackage.getEClassifiers());
            Collections.sort(eclassifiers, this.eclassComparator);
            for (EClassifier eclassifier : eclassifiers) {
                if (!(eclassifier instanceof EClass)) continue;
                drawer.add((PaletteEntry)new EClassNodeToolEntry((EClass)eclassifier));
            }
            this.palette.add((PaletteEntry)drawer);
            this.drawers.put(epackage, drawer);
        }
    }

    public void dispose() {
        this.system.eAdapters().remove((Object)this.listener);
    }

    static class EClassNodeTool
    extends UnspecifiedTypeCreationTool {
        private static final List<IElementType> types = new ArrayList<IElementType>(1);
        private Map<Object, Object> parameters = new HashMap<Object, Object>();

        static {
            types.add(HenshinElementTypes.Node_3001);
        }

        public EClassNodeTool(EClass eclass) {
            super(types);
            this.parameters.put("henshin_node_type", eclass);
        }

        protected Request createTargetRequest() {
            Request request = super.createTargetRequest();
            request.setExtendedData(this.parameters);
            return request;
        }
    }

    static class EClassNodeToolEntry
    extends ToolEntry {
        private EClass eclass;

        public EClassNodeToolEntry(EClass eclass) {
            super(eclass.getName(), "Create a " + eclass.getName() + " node", ECLASS_ICON, null);
            this.eclass = eclass;
        }

        public Tool createTool() {
            EClassNodeTool tool = new EClassNodeTool(this.eclass);
            tool.setProperties(this.getToolProperties());
            return tool;
        }
    }
}

