/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.common.util.EmfGraph;
import org.eclipse.emf.henshin.common.util.TransformationOptions;
import org.eclipse.emf.henshin.internal.change.ModelChange;
import org.eclipse.emf.henshin.internal.conditions.attribute.AttributeConditionHandler;
import org.eclipse.emf.henshin.internal.conditions.nested.AndFormula;
import org.eclipse.emf.henshin.internal.conditions.nested.ApplicationCondition;
import org.eclipse.emf.henshin.internal.conditions.nested.IFormula;
import org.eclipse.emf.henshin.internal.conditions.nested.NotFormula;
import org.eclipse.emf.henshin.internal.conditions.nested.OrFormula;
import org.eclipse.emf.henshin.internal.conditions.nested.TrueFormula;
import org.eclipse.emf.henshin.internal.interpreter.AmalgamationInfo;
import org.eclipse.emf.henshin.internal.interpreter.ChangeInfo;
import org.eclipse.emf.henshin.internal.interpreter.ConditionInfo;
import org.eclipse.emf.henshin.internal.interpreter.RuleInfo;
import org.eclipse.emf.henshin.internal.interpreter.VariableInfo;
import org.eclipse.emf.henshin.internal.matching.DomainSlot;
import org.eclipse.emf.henshin.internal.matching.Matchfinder;
import org.eclipse.emf.henshin.internal.matching.Solution;
import org.eclipse.emf.henshin.internal.matching.Variable;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.interpreter.util.ModelHelper;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class EmfEngine
implements InterpreterEngine {
    EmfGraph emfGraph;
    ScriptEngine scriptEngine;
    Map<Rule, RuleInfo> ruleInformation = new HashMap<Rule, RuleInfo>();
    TransformationOptions options;

    public EmfEngine() {
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.scriptEngine = mgr.getEngineByName("JavaScript");
        this.options = new TransformationOptions();
    }

    public EmfEngine(EmfGraph emfGraph) {
        this();
        this.emfGraph = emfGraph;
    }

    private Matchfinder prepareMatchfinder(RuleApplication ruleApplication) {
        Rule rule = ruleApplication.getRule();
        RuleInfo ruleInfo = this.getRuleInformation(rule);
        ConditionInfo conditionInfo = ruleInfo.getConditionInfo();
        VariableInfo variableInfo = ruleInfo.getVariableInfo();
        Map<Parameter, Object> parameterValues = ruleApplication.getMatch().getParameterValues();
        Map<Node, EObject> prematch = ModelHelper.createPrematch((TransformationUnit)rule, parameterValues);
        Map<Node, EObject> rulePrematch = ruleApplication.getMatch().getNodeMapping();
        for (Node node : rulePrematch.keySet()) {
            prematch.put(node, rulePrematch.get(node));
        }
        AttributeConditionHandler conditionHandler = new AttributeConditionHandler(conditionInfo.getConditionParameters(), this.scriptEngine);
        HashSet usedObjects = new HashSet();
        HashMap<Variable, DomainSlot> domainMap = new HashMap<Variable, DomainSlot>();
        for (Variable mainVariable : variableInfo.getMainVariables()) {
            Node node = variableInfo.getVariableForNode(mainVariable);
            TransformationOptions options = this.getOptions();
            if (node.getGraph() != ruleInfo.getRule().getLhs()) {
                options = new TransformationOptions();
                options.setDeterministic(true);
                options.setInjective(true);
                options.setDangling(false);
            }
            DomainSlot domainSlot = new DomainSlot(conditionHandler, usedObjects, options);
            if (prematch.get(node) != null) {
                domainSlot.fixInstanciation(prematch.get(node));
            }
            for (Variable dependendVariable : variableInfo.getDependendVariables(mainVariable)) {
                domainMap.put(dependendVariable, domainSlot);
            }
        }
        if (parameterValues != null) {
            for (Parameter parameter : parameterValues.keySet()) {
                conditionHandler.setParameter(parameter.getName(), parameterValues.get(parameter));
            }
        }
        Map<Graph, List<Variable>> graphMap = variableInfo.getGraph2variables();
        Matchfinder matchfinder = new Matchfinder(this.emfGraph, domainMap, conditionHandler);
        matchfinder.setVariables(graphMap.get(rule.getLhs()));
        matchfinder.setFormula(this.initFormula(rule.getLhs().getFormula(), domainMap, graphMap, conditionHandler));
        return matchfinder;
    }

    private IFormula initFormula(Formula formula, Map<Variable, DomainSlot> domainMap, Map<Graph, List<Variable>> graphMap, AttributeConditionHandler conditionHandler) {
        if (formula instanceof And) {
            And and = (And)formula;
            IFormula left = this.initFormula(and.getLeft(), domainMap, graphMap, conditionHandler);
            IFormula right = this.initFormula(and.getRight(), domainMap, graphMap, conditionHandler);
            AndFormula andFormula = new AndFormula(left, right);
            return andFormula;
        }
        if (formula instanceof Or) {
            Or or = (Or)formula;
            IFormula left = this.initFormula(or.getLeft(), domainMap, graphMap, conditionHandler);
            IFormula right = this.initFormula(or.getRight(), domainMap, graphMap, conditionHandler);
            OrFormula orFormula = new OrFormula(left, right);
            return orFormula;
        }
        if (formula instanceof Not) {
            Not not = (Not)formula;
            IFormula child = this.initFormula(not.getChild(), domainMap, graphMap, conditionHandler);
            NotFormula notFormula = new NotFormula(child);
            return notFormula;
        }
        if (formula instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)formula;
            ApplicationCondition ac = this.initApplicationCondition(nc, domainMap, graphMap, conditionHandler);
            return ac;
        }
        return new TrueFormula();
    }

    private ApplicationCondition initApplicationCondition(NestedCondition nc, Map<Variable, DomainSlot> domainMap, Map<Graph, List<Variable>> graphMap, AttributeConditionHandler conditionHandler) {
        ApplicationCondition ac = new ApplicationCondition(this.emfGraph, domainMap, nc.isNegated());
        ac.setVariables(graphMap.get(nc.getConclusion()));
        ac.setFormula(this.initFormula(nc.getConclusion().getFormula(), domainMap, graphMap, conditionHandler));
        return ac;
    }

    private RuleInfo getRuleInformation(Rule rule) {
        RuleInfo ruleInfo = this.ruleInformation.get(rule);
        if (ruleInfo == null) {
            ruleInfo = new RuleInfo(rule, this.scriptEngine);
            this.ruleInformation.put(rule, ruleInfo);
        }
        return ruleInfo;
    }

    @Override
    public List<Match> findAllMatches(RuleApplication ruleApplication) {
        if (this.emfGraph == null) {
            throw new IllegalArgumentException("no target graph was specified for the engine");
        }
        Rule rule = ruleApplication.getRule();
        RuleInfo ruleInfo = this.getRuleInformation(rule);
        Matchfinder matchfinder = this.prepareMatchfinder(ruleApplication);
        List solutions = matchfinder.getAllMatches();
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Solution solution : solutions) {
            Match match = new Match(rule, solution, ruleInfo.getVariableInfo().getNode2variable());
            matches.add(match);
        }
        return matches;
    }

    @Override
    public Match findMatch(RuleApplication ruleApplication) {
        if (this.emfGraph == null) {
            throw new IllegalArgumentException("no target graph was specified for the engine");
        }
        Rule rule = ruleApplication.getRule();
        RuleInfo ruleInfo = this.getRuleInformation(rule);
        Matchfinder matchfinder = this.prepareMatchfinder(ruleApplication);
        Solution solution = matchfinder.getNextMatch();
        if (solution != null) {
            Match match = new Match(rule, solution, ruleInfo.getVariableInfo().getNode2variable());
            return match;
        }
        return null;
    }

    @Override
    public RuleApplication generateAmalgamationRule(AmalgamationUnit amalgamationUnit, Map<Parameter, Object> parameterValues) {
        AmalgamationInfo amalgamationWrapper = new AmalgamationInfo(this, amalgamationUnit, parameterValues);
        return amalgamationWrapper.getAmalgamationRule();
    }

    @Override
    public Match applyRule(RuleApplication ruleApplication) {
        Match match = this.findMatch(ruleApplication);
        if (match != null) {
            ruleApplication.setMatch(match);
            Match comatch = this.executeModelChanges(ruleApplication);
            ruleApplication.setComatch(comatch);
            return comatch;
        }
        return null;
    }

    public void purgeCache() {
        this.ruleInformation.clear();
    }

    private Match executeModelChanges(RuleApplication ruleApplication) {
        Rule rule = ruleApplication.getRule();
        RuleInfo ruleInfo = this.getRuleInformation(rule);
        ChangeInfo changeInfo = ruleInfo.getChangeInfo();
        Match match = ruleApplication.getMatch();
        if (!match.isComplete()) {
            return null;
        }
        ModelChange modelChange = new ModelChange();
        Map<Node, EObject> matchNodeMapping = match.getNodeMapping();
        HashMap<Node, EObject> comatchNodeMapping = new HashMap<Node, EObject>();
        HashMap<Parameter, Object> comatchParameterValues = new HashMap<Parameter, Object>();
        comatchParameterValues.putAll(match.getParameterValues());
        for (Node node : changeInfo.getCreatedNodes()) {
            Parameter parameter;
            EClass type = node.getType();
            EPackage ePackage = type.getEPackage();
            EObject newObject = ePackage.getEFactoryInstance().create(type);
            modelChange.addCreatedObject(newObject);
            this.emfGraph.addEObject(newObject);
            comatchNodeMapping.put(node, newObject);
            if (node.getName() == null || node.getName().isEmpty() || (parameter = rule.getParameterByName(node.getName())) == null) continue;
            comatchParameterValues.put(parameter, newObject);
        }
        for (Node node : changeInfo.getDeletedNodes()) {
            modelChange.addDeletedObject(match.getNodeMapping().get(node));
            this.emfGraph.removeEObject(match.getNodeMapping().get(node));
        }
        for (Node node : changeInfo.getPreservedNodes()) {
            Parameter parameter;
            Node lhsNode = ModelHelper.getRemoteNode((Collection<Mapping>)rule.getMappings(), node);
            EObject targetObject = matchNodeMapping.get(lhsNode);
            comatchNodeMapping.put(node, targetObject);
            if (node.getName() == null || node.getName().isEmpty() || (parameter = rule.getParameterByName(node.getName())) == null) continue;
            comatchParameterValues.put(parameter, targetObject);
        }
        for (Edge edge : changeInfo.getDeletedEdges()) {
            modelChange.addObjectChange(matchNodeMapping.get(edge.getSource()), (EStructuralFeature)edge.getType(), (Object)matchNodeMapping.get(edge.getTarget()), true);
        }
        for (Edge edge : changeInfo.getCreatedEdges()) {
            modelChange.addObjectChange((EObject)comatchNodeMapping.get(edge.getSource()), (EStructuralFeature)edge.getType(), comatchNodeMapping.get(edge.getTarget()), false);
        }
        for (Attribute attribute : changeInfo.getAttributeChanges()) {
            EObject targetObject = (EObject)comatchNodeMapping.get(attribute.getNode());
            Object value = this.evalAttributeExpression(match.getParameterValues(), attribute);
            String valueString = null;
            if (value != null && (valueString = value.toString()).endsWith(".0")) {
                valueString = valueString.substring(0, valueString.length() - 2);
            }
            value = EcoreUtil.createFromString((EDataType)attribute.getType().getEAttributeType(), (String)valueString);
            modelChange.addObjectChange(targetObject, (EStructuralFeature)attribute.getType(), value, false);
        }
        modelChange.applyChanges();
        ruleApplication.setModelChange(modelChange);
        return new Match(rule, comatchParameterValues, comatchNodeMapping);
    }

    private Object evalAttributeExpression(Map<Parameter, Object> parameterMapping, Attribute attribute) {
        EEnum eenum;
        EEnumLiteral eelit;
        if (attribute.getType() != null && attribute.getType().getEType() instanceof EEnum && (eelit = (eenum = (EEnum)attribute.getType().getEType()).getEEnumLiteral(attribute.getValue())) != null) {
            return eelit;
        }
        try {
            for (Parameter parameter : parameterMapping.keySet()) {
                this.scriptEngine.put(parameter.getName(), parameterMapping.get(parameter));
            }
            return this.scriptEngine.eval(attribute.getValue());
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void redoChanges(RuleApplication ruleApplication) {
        ModelChange modelChange = ruleApplication.getModelChange();
        for (EObject createdObject : modelChange.getCreatedObjects()) {
            this.emfGraph.addEObject(createdObject);
        }
        for (EObject deletedObject : modelChange.getDeletedObjects()) {
            this.emfGraph.removeEObject(deletedObject);
        }
        modelChange.redoChanges();
    }

    @Override
    public void undoChanges(RuleApplication ruleApplication) {
        ModelChange modelChange = ruleApplication.getModelChange();
        modelChange.undoChanges();
        for (EObject deletedObject : modelChange.getDeletedObjects()) {
            this.emfGraph.addEObject(deletedObject);
        }
        for (EObject createdObject : modelChange.getCreatedObjects()) {
            this.emfGraph.removeEObject(createdObject);
        }
    }

    public EmfGraph getEmfGraph() {
        return this.emfGraph;
    }

    public void setEmfGraph(EmfGraph emfGraph) {
        this.emfGraph = emfGraph;
    }

    public TransformationOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(TransformationOptions options) {
        this.options = options;
    }
}

