/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ViewComponentEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class LinkEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4002;

    public LinkEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ViewComponentEditPolicy());
        this.removeEditPolicy("SemanticPolicy");
    }

    private void updateArrow(LinkFigure figure) {
        if (figure != null) {
            TransformationUnit unit = this.getTransformationUnit();
            figure.setTargetDecoration(null);
            figure.removeAll();
            if (unit instanceof PriorityUnit) {
                figure.add((IFigure)this.createArrowDecoration(4, 7), (Object)new MiddleLocator((Connection)figure));
            } else {
                figure.setTargetDecoration(this.createArrowDecoration(7, 3));
            }
        }
    }

    private TransformationUnit getTransformationUnit() {
        View sourceNode = ((Edge)this.getNotationView()).getSource();
        if (sourceNode == null) {
            return null;
        }
        View compartment = (View)sourceNode.eContainer();
        if (compartment == null) {
            return null;
        }
        View unitView = (View)compartment.eContainer();
        if (unitView == null) {
            return null;
        }
        if (unitView.getElement() instanceof TransformationUnit) {
            return (TransformationUnit)unitView.getElement();
        }
        return null;
    }

    private RotatableDecoration createArrowDecoration(int length, int width) {
        PolygonDecoration df = new PolygonDecoration();
        df.setFill(true);
        PointList pl = new PointList();
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(1));
        pl.addPoint(this.getMapMode().DPtoLP(0), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(-1));
        df.setTemplate(pl);
        df.setScale((double)this.getMapMode().DPtoLP(length), (double)this.getMapMode().DPtoLP(width));
        return df;
    }

    public Command getCommand(Request request) {
        Object type = request.getType();
        if ("delete".equals(type) || "Reconnection source".equals(type) || "Reconnection target".equals(type)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(request);
    }

    protected Connection createConnectionFigure() {
        LinkFigure linkFigure = new LinkFigure();
        this.updateArrow(linkFigure);
        return linkFigure;
    }

    public LinkFigure getPrimaryShape() {
        return (LinkFigure)this.getFigure();
    }

    public class LinkFigure
    extends PolylineConnectionEx {
        public LinkFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.setTargetDecoration(this.createTargetDecoration());
        }

        private RotatableDecoration createTargetDecoration() {
            PolygonDecoration df = new PolygonDecoration();
            df.setFill(true);
            PointList pl = new PointList();
            pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(-1), LinkEditPart.this.getMapMode().DPtoLP(1));
            pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(0), LinkEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(-1), LinkEditPart.this.getMapMode().DPtoLP(-1));
            df.setTemplate(pl);
            df.setScale((double)LinkEditPart.this.getMapMode().DPtoLP(7), (double)LinkEditPart.this.getMapMode().DPtoLP(3));
            return df;
        }
    }

    private class MiddleLocator
    extends ConnectionLocator {
        public MiddleLocator(Connection arg0) {
            super(arg0);
        }

        public void relocate(IFigure target) {
            PointList points = this.getConnection().getPoints();
            RotatableDecoration box = (RotatableDecoration)target;
            box.setLocation(this.getLocation(points));
            int midPoint = points.size() / 2;
            box.setReferencePoint(points.getPoint(midPoint - 1));
        }
    }
}

