/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.io.File;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.matching.util.TransformationOptions;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.testframework.HenshinLoaders;
import org.junit.After;

public class HenshinTest {
    protected TransformationSystem htTransformationSystem;
    protected EmfEngine htEngine;
    protected EmfGraph htEmfGraph;
    protected Rule htRule;
    protected RuleApplication htRuleApp;
    protected TransformationUnit htTransUnit;
    protected UnitApplication htUnitApp;
    protected String graphBasePath = "";
    protected String graphFileExtension = "";

    @After
    public void tearDown() {
        this.htTransformationSystem = null;
        this.htEngine = null;
        this.htEmfGraph = null;
        this.htRule = null;
        this.htRuleApp = null;
        this.htTransUnit = null;
        this.htUnitApp = null;
    }

    protected void init(String henshinFile) throws Exception {
        this.htTransformationSystem = HenshinLoaders.loadHenshin(henshinFile);
    }

    protected void init(String henshinFile, String modelFile, String modelFileExt) throws Exception {
        this.htTransformationSystem = HenshinLoaders.loadHenshin(henshinFile);
        this.htEngine = HenshinLoaders.loadEngine(modelFile, modelFileExt);
        this.htEmfGraph = this.htEngine.getEmfGraph();
    }

    protected void init(String henshinFile, String modelFile, String modelFileExt, TransformationOptions options) throws Exception {
        this.htTransformationSystem = HenshinLoaders.loadHenshin(henshinFile);
        this.htEngine = HenshinLoaders.loadEngine(modelFile, modelFileExt);
        this.htEngine.setOptions(options);
        this.htEmfGraph = this.htEngine.getEmfGraph();
    }

    protected void init(String modelFile, String modelFileExt) throws Exception {
        this.htEngine = HenshinLoaders.loadEngine(modelFile, modelFileExt);
        this.htEmfGraph = this.htEngine.getEmfGraph();
    }

    protected void init(String modelFile, String modelFileExt, TransformationOptions options) throws Exception {
        this.htEngine = HenshinLoaders.loadEngine(modelFile, modelFileExt);
        this.htEngine.setOptions(options);
        this.htEmfGraph = this.htEngine.getEmfGraph();
    }

    protected void loadRule(String ruleName) {
        this.htRule = this.htTransformationSystem.findRuleByName(ruleName);
        this.htRuleApp = new RuleApplication((InterpreterEngine)this.htEngine, this.htRule);
    }

    protected void loadRule(String ruleName, String paramName, Object paramValue) {
        this.loadRule(ruleName);
        this.htRuleApp.setParameterValue(paramName, paramValue);
    }

    protected void loadRule(String ruleName, Map<String, Object> paramMappings) {
        this.loadRule(ruleName);
        this.htRuleApp.setParameterValues(paramMappings);
    }

    protected void loadTu(String unitName) {
        this.htTransUnit = this.htTransformationSystem.findUnitByName(unitName);
        this.htUnitApp = new UnitApplication((InterpreterEngine)this.htEngine, this.htTransUnit);
    }

    protected void loadTu(String unitName, String paramName, Object paramValue) {
        this.loadTu(unitName);
        this.htUnitApp.setParameterValue(paramName, paramValue);
    }

    protected void loadTu(String unitName, Map<String, Object> paramMappings) {
        this.loadTu(unitName);
        this.htUnitApp.setParameterValues(paramMappings);
    }

    protected void loadGraph(EmfGraph graph) {
        this.htEmfGraph = graph;
        this.htEngine = new EmfEngine(this.htEmfGraph);
    }

    protected void loadEmbeddedGraph(String embeddedGraphName) {
        this.loadGraph(HenshinLoaders.loadEmbeddedGraph(embeddedGraphName, this.htTransformationSystem));
    }

    protected void loadGraph(String fileName) {
        URI graphURI = URI.createFileURI((String)new File(String.valueOf(this.graphBasePath) + fileName + "." + this.graphFileExtension).getAbsolutePath());
        this.loadGraph(HenshinLoaders.loadGraph(graphURI));
    }

    protected void setModelGraphProperties(String graphPath, String fileExtension) {
        this.graphBasePath = graphPath;
        this.graphFileExtension = fileExtension;
    }

    protected URI getGraphURI(String graphName) {
        URI graphURI = URI.createFileURI((String)new File(String.valueOf(this.graphBasePath) + graphName + "." + this.graphFileExtension).getAbsolutePath());
        return graphURI;
    }
}

