/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.StateExplorer;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceIndexImpl;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;
import org.eclipse.emf.henshin.statespace.util.StateDistanceMonitor;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;

public class SingleThreadedStateSpaceManager
extends StateSpaceIndexImpl
implements StateSpaceManager {
    protected final Stack<StateExplorer> explorers = new Stack();
    protected final Object stateSpaceLock = new Object();
    protected StateDistanceMonitor stateDistanceMonitor;

    public SingleThreadedStateSpaceManager(StateSpace stateSpace) {
        super(stateSpace);
        this.refreshHelpers();
    }

    protected void refreshHelpers() {
        this.getStateSpace().updateEqualityHelper();
        this.stateDistanceMonitor = this.getStateSpace().getMaxStateDistance() >= 0 ? new StateDistanceMonitor(this.getStateSpace()) : null;
        this.clearCache();
    }

    @Override
    public void reload(IProgressMonitor monitor) throws StateSpaceException {
        monitor.beginTask("Reload models", this.getStateSpace().getStates().size() + 3);
        StateSpace stateSpace = this.getStateSpace();
        EqualityHelper equalityHelper = stateSpace.getEqualityHelper();
        this.refreshHelpers();
        monitor.worked(1);
        try {
            try {
                this.resetIndex();
                monitor.worked(1);
                for (State state : stateSpace.getStates()) {
                    if (state.isInitial()) {
                        state.setDerivedFrom(-1);
                        continue;
                    }
                    state.setModel(null);
                }
                monitor.worked(1);
                boolean useObjectKeys = !equalityHelper.getIdentityTypes().isEmpty();
                for (State state : stateSpace.getStates()) {
                    Model model = this.getModel(state);
                    if (useObjectKeys) {
                        model.updateObjectKeys(equalityHelper.getIdentityTypes());
                        state.setObjectKeys(model.getObjectKeys());
                    }
                    state.setObjectCount(model.getEGraph().size());
                    int hash = equalityHelper.hashCode(model);
                    if (this.getState(model, hash) != null) {
                        throw new StateSpaceException("Duplicate state: " + state.getIndex());
                    }
                    state.setHashCode(hash);
                    state.setOpen(this.isOpen(state));
                    this.addToIndex(state);
                    monitor.worked(1);
                }
            }
            catch (Throwable t) {
                throw new StateSpaceException(t);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean isOpen(State state) throws StateSpaceException {
        StateExplorer explorer = this.acquireExplorer();
        List<Transition> transitions = explorer.doExplore(state);
        HashSet<Transition> matched = new HashSet<Transition>();
        for (Transition current : transitions) {
            State generated = current.getTarget();
            State target = this.getState(generated.getModel(), generated.getHashCode());
            if (target == null) {
                this.releaseExplorer(explorer);
                return true;
            }
            Transition transition = state.findOutgoing(target, current.getRule(), current.getMatch(), current.getParameterKeys());
            if (transition == null) {
                this.releaseExplorer(explorer);
                return true;
            }
            matched.add(transition);
        }
        this.releaseExplorer(explorer);
        if (!matched.containsAll((Collection<?>)state.getOutgoing())) {
            throw new StateSpaceException("Illegal transition in state " + state.getIndex());
        }
        return false;
    }

    protected final State createOpenState(Model model, int hash, State derivedFrom, int[] location) {
        State state = StateSpaceFactory.eINSTANCE.createState();
        state.setIndex(this.getStateSpace().getStates().size());
        state.setHashCode(hash);
        state.setDerivedFrom(derivedFrom != null ? derivedFrom.getIndex() : -1);
        state.setModel(model);
        state.setOpen(true);
        if (location != null) {
            state.setLocation(location);
        }
        if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
            int[] objectKeys = model.getObjectKeys();
            state.setObjectKeys(objectKeys);
            state.setObjectCount(objectKeys.length);
        }
        this.getStateSpace().getStates().add((Object)state);
        this.getStateSpace().getOpenStates().add(state);
        if (this.stateDistanceMonitor != null) {
            this.stateDistanceMonitor.updateDistance(state);
        }
        this.addToIndex(state);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final State createInitialState(Model model) throws StateSpaceException {
        int hash;
        State state;
        Resource resource = model.getResource();
        if (resource == null || resource.getURI() == null) {
            throw new IllegalArgumentException("Model is not persisted");
        }
        EcoreUtil.resolveAll((EObject)model);
        if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
            model.updateObjectKeys(this.getStateSpace().getEqualityHelper().getIdentityTypes());
        }
        if ((state = this.getState(model, hash = this.getStateSpace().getEqualityHelper().hashCode(model))) != null) {
            return state;
        }
        State initial = this.createOpenState(model, hash, null, null);
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.getStateSpace().getInitialStates().add((Object)initial);
            if (this.stateDistanceMonitor != null) {
                this.stateDistanceMonitor.updateDistance(state);
            }
        }
        return initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<State> removeState(State state) throws StateSpaceException {
        ArrayList<State> removed = new ArrayList<State>();
        Object object = this.stateSpaceLock;
        synchronized (object) {
            if (this.getStateSpace().removeState(state)) {
                removed.addAll(StateSpaceSearch.removeUnreachableStates(this.getStateSpace()));
                removed.add(state);
            }
            this.getStateSpace().getOpenStates().removeAll(removed);
            this.getStateSpace().getInitialStates().removeAll(removed);
            HashSet<Transition> transitions = new HashSet<Transition>();
            for (State current : removed) {
                this.removeFromIndex(current);
                transitions.addAll((Collection<Transition>)current.getOutgoing());
                transitions.addAll((Collection<Transition>)current.getIncoming());
            }
            int number = this.getStateSpace().getTransitionCount() - transitions.size();
            this.getStateSpace().setTransitionCount(number);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resetStateSpace() throws StateSpaceException {
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.getStateSpace().updateEqualityHelper();
            this.getStateSpace().getStates().clear();
            this.getStateSpace().getOpenStates().clear();
            this.getStateSpace().getStates().addAll(this.getStateSpace().getInitialStates());
            for (State initial : this.getStateSpace().getStates()) {
                initial.getOutgoing().clear();
                initial.getIncoming().clear();
            }
            this.getStateSpace().setTransitionCount(0);
            for (State initial : this.getStateSpace().getStates()) {
                Model model = initial.getModel();
                model.setObjectKeys(StorageImpl.EMPTY_DATA);
                if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
                    model.updateObjectKeys(this.getStateSpace().getEqualityHelper().getIdentityTypes());
                }
                initial.setObjectKeys(model.getObjectKeys());
            }
            this.reload((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected State findState(Model model, int hashCode, Collection<State> states) throws StateSpaceException {
        for (State state : states) {
            if (hashCode != state.getHashCode() || !this.getStateSpace().getEqualityHelper().equals(model, this.getModel(state))) continue;
            return state;
        }
        return null;
    }

    @Override
    public int getStateDistance(State state) {
        if (this.stateDistanceMonitor != null) {
            return this.stateDistanceMonitor.getDistance(state);
        }
        return -1;
    }

    @Override
    protected Model deriveModel(State state, boolean fromInitial) throws StateSpaceException {
        Path trace = new Path();
        State source = state;
        Model start = null;
        EList<State> states = this.getStateSpace().getStates();
        try {
            while (start == null) {
                State target = source;
                source = (State)states.get(target.getDerivedFrom());
                trace.addFirst(source.findOutgoing(target, null, -1, null));
                start = this.getCachedModel(source);
                if (!fromInitial || source.isInitial()) continue;
                start = null;
            }
        }
        catch (Throwable t) {
            throw new StateSpaceException("Error deriving model for " + state, t);
        }
        StateExplorer explorer = this.acquireExplorer();
        Model model = explorer.deriveModel(trace, start);
        this.releaseExplorer(explorer);
        return model;
    }

    @Override
    public List<State> exploreStates(List<State> states, boolean generateLocation) throws StateSpaceException {
        ArrayList<State> result = new ArrayList<State>();
        try {
            for (State state : states) {
                result.addAll(this.exploreState(state, generateLocation));
            }
        }
        catch (Throwable t) {
            if (t instanceof StateSpaceException) {
                throw (StateSpaceException)t;
            }
            throw new StateSpaceException(t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<State> exploreState(State state, boolean generateLocation) throws StateSpaceException {
        int maxDistance = this.getStateSpace().getMaxStateDistance();
        if (maxDistance >= 0 && this.getStateDistance(state) >= maxDistance) {
            return Collections.emptyList();
        }
        StateExplorer explorer = this.acquireExplorer();
        List<Transition> transitions = explorer.doExplore(state);
        if (transitions.isEmpty()) {
            this.releaseExplorer(explorer);
            Object object = this.stateSpaceLock;
            synchronized (object) {
                state.setOpen(false);
            }
            return Collections.emptyList();
        }
        int newStates = 0;
        ArrayList<State> result = new ArrayList<State>(transitions.size());
        int count = transitions.size();
        int i = 0;
        while (i < count) {
            State target;
            Transition t = transitions.get(i);
            Rule rule = t.getRule();
            int match = t.getMatch();
            int[] parameters = t.getParameterKeys();
            int hashCode = t.getTarget().getHashCode();
            Model transformed = t.getTarget().getModel();
            boolean newState = false;
            int[] location = generateLocation ? SingleThreadedStateSpaceManager.shiftedLocation(state, newStates++) : null;
            try {
                target = this.getState(transformed, hashCode);
            }
            catch (Throwable throwable) {
                target = null;
            }
            Object object = this.stateSpaceLock;
            synchronized (object) {
                if (target == null) {
                    target = this.getState(transformed, hashCode);
                } else if (target.getStateSpace() == null) {
                    target = null;
                }
                if (target == null) {
                    target = this.createOpenState(transformed, hashCode, state, location);
                    newState = true;
                }
                if (newState || state.findOutgoing(target, rule, match, parameters) == null) {
                    t.setSource(state);
                    t.setTarget(target);
                    this.getStateSpace().incTransitionCount();
                    if (this.stateDistanceMonitor != null) {
                        this.stateDistanceMonitor.updateDistance(target);
                    }
                }
                if (newState) {
                    this.addToCache(target, transformed);
                    result.add(target);
                }
                if (i == count - 1) {
                    state.setOpen(false);
                }
            }
            ++i;
        }
        this.releaseExplorer(explorer);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateExplorer acquireExplorer() {
        Stack<StateExplorer> stack = this.explorers;
        synchronized (stack) {
            try {
                return this.explorers.pop();
            }
            catch (Throwable throwable) {
                return new StateExplorer(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseExplorer(StateExplorer explorer) {
        Stack<StateExplorer> stack = this.explorers;
        synchronized (stack) {
            this.explorers.push(explorer);
        }
    }

    protected static int[] shiftedLocation(State base, int index) {
        int[] location = base.getLocation();
        double angle = Math.PI * (double)index * 0.17;
        location[0] = (int)((double)location[0] + 60.0 * Math.cos(angle));
        location[1] = (int)((double)location[1] + 60.0 * Math.sin(angle));
        return location;
    }

    @Override
    public int getNumThreads() {
        return 1;
    }

    @Override
    public void shutdown() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Stack<StateExplorer> stack = this.explorers;
        synchronized (stack) {
            this.explorers.clear();
        }
    }
}

