/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.impl.CacheImpl;

public class StateSpaceIndexImpl
implements StateSpaceIndex {
    private static final int INITIAL_INDEX_SIZE = 4093;
    private final Map<State, Model> stateModelCache = Collections.synchronizedMap(new CacheImpl());
    private State[][] index;
    private StateSpace stateSpace;
    private int entries;

    public StateSpaceIndexImpl(StateSpace stateSpace) {
        if (stateSpace == null) {
            throw new NullPointerException();
        }
        this.stateSpace = stateSpace;
        this.resetIndex();
        for (State state : this.getStateSpace().getStates()) {
            this.addToIndex(state);
        }
    }

    @Override
    public Model getModel(State state) throws StateSpaceException {
        Model model = this.getCachedModel(state);
        if (model == null && (model = this.deriveModel(state, false)) != null) {
            this.addToCache(state, model);
        }
        return model;
    }

    protected Model getCachedModel(State state) {
        Model model = state.getModel();
        if (model != null) {
            return model;
        }
        return this.stateModelCache.get(state);
    }

    protected void addToCache(State state, Model model) throws StateSpaceException {
        if (state.isInitial()) {
            return;
        }
        this.stateModelCache.put(state, model);
        int states = this.getStateSpace().getStateCount();
        int index = state.getIndex() + 1;
        int threshold = 5000;
        int stored = 1;
        while (states >= threshold) {
            threshold *= 10;
            ++stored;
        }
        if (index % stored != 0) {
            model = null;
        }
        state.setModel(model);
    }

    protected Model deriveModel(State state, boolean fromInitial) throws StateSpaceException {
        return null;
    }

    @Override
    public final State getState(Model model) throws StateSpaceException {
        return this.getState(model, this.stateSpace.getEqualityHelper().hashCode(model));
    }

    protected State getState(Model model, int hash) throws StateSpaceException {
        if (model == null) {
            throw new NullPointerException("Cannot look up state for null model");
        }
        int position = this.hash2position(hash);
        State[] matched = this.index[position];
        if (matched == null) {
            return null;
        }
        int i = 0;
        while (i < matched.length) {
            State cand = matched[i];
            if (cand != null && cand.getHashCode() == hash) {
                Model current = this.getModel(cand);
                if (this.stateSpace.getEqualityHelper().equals(model, current)) {
                    return cand;
                }
            }
            ++i;
        }
        return null;
    }

    public void addToIndex(State state) {
        int hashcode;
        int position;
        if (this.index.length < 2 * this.entries) {
            this.grow();
        }
        if (this.index[position = this.hash2position(hashcode = state.getHashCode())] == null) {
            this.index[position] = new State[4];
        }
        int minor = this.index[position].length;
        int i = 0;
        while (i < this.index[position].length) {
            if (this.index[position][i] == null) {
                minor = i;
            }
            ++i;
        }
        if (minor >= this.index[position].length) {
            this.index[position] = Arrays.copyOf(this.index[position], this.index[position].length * 2);
        }
        this.index[position][minor] = state;
        ++this.entries;
    }

    public void removeFromIndex(State state) {
        int position = this.hash2position(state.getHashCode());
        State[] matched = this.index[position];
        if (matched == null) {
            return;
        }
        int i = 0;
        while (i < matched.length) {
            if (matched[i] == state) {
                matched[i] = null;
                --this.entries;
                return;
            }
            ++i;
        }
    }

    public void resetIndex() {
        this.index = new State[this.optimalSize()][];
        this.entries = 0;
    }

    @Override
    public StateSpace getStateSpace() {
        return this.stateSpace;
    }

    private void grow() {
        State[][] oldIndex = this.index;
        this.resetIndex();
        int i = 0;
        while (i < oldIndex.length) {
            if (oldIndex[i] != null) {
                int j = 0;
                while (j < oldIndex[i].length) {
                    if (oldIndex[i][j] != null) {
                        this.addToIndex(oldIndex[i][j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private int hash2position(int hash) {
        return Math.abs(hash) % this.index.length;
    }

    private int optimalSize() {
        int size = this.stateSpace.getStates().size() * 4 + 1;
        return size < 4093 ? 4093 : size;
    }

    @Override
    public void clearCache() {
        for (State state : this.getStateSpace().getStates()) {
            if (state.isInitial()) continue;
            state.setModel(null);
        }
        this.stateModelCache.clear();
        System.gc();
    }
}

