/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.ecore2genmodel;

import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class Ecore2GenmodelTrafo {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/ecore2genmodel";

    public static void generateEcore2Genmodel(String path) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        resourceSet.registerXMIResourceFactories(new String[]{"genmodel"});
        GenModelPackage.eINSTANCE.getName();
        TransformationSystem system = resourceSet.getTransformationSystem("Ecore2Genmodel.henshin");
        EPackage mappingModel = (EPackage)resourceSet.getObject("ecore2gen.ecore");
        EPackage ecoreModel = (EPackage)resourceSet.getObject("flowchartdsl.ecore");
        EGraph graph = InterpreterFactory.INSTANCE.createEGraph();
        graph.addTree((EObject)ecoreModel);
        Engine engine = InterpreterFactory.INSTANCE.createEngine();
        UnitApplication unitApp = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        unitApp.setEGraph(graph);
        unitApp.setUnit(system.findUnitByName("translateGenModel"));
        unitApp.setParameterValue("modelFileName", (Object)"flowchartdsl.ecore");
        unitApp.setParameterValue("pluginName", (Object)ecoreModel.getName());
        if (!unitApp.execute(null)) {
            System.err.println("Error generating Genmodel");
        }
        GenModel gm = (GenModel)unitApp.getResultParameterValue("genModel");
        graph.addTree((EObject)system);
        graph.addTree((EObject)GenModelPackage.eINSTANCE);
        graph.addTree((EObject)mappingModel);
        unitApp.setUnit(system.findUnitByName("prepareCustomizationUnit"));
        unitApp.execute(null);
        unitApp.setUnit((TransformationUnit)unitApp.getResultParameterValue("seqUnit"));
        unitApp.execute(null);
        resourceSet.saveObject((EObject)gm, "flowchartdsl2.genmodel");
        System.out.println("Saved the result to flowchartdsl2.genmodel");
    }

    public static void main(String[] args) {
        Ecore2GenmodelTrafo.generateEcore2Genmodel(PATH);
    }
}

