/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.java2statemachine;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.util.EGraphIsomorphyChecker;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class Java2StateMachine {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/java2statemachine";
    public static final String JAVA_MODEL_SMALL = "1-java-model-small.xmi";
    public static final String JAVA_MODEL_MEDIUM = "2-java-model-medium.xmi";
    public static final String JAVA_MODEL_BIG = "3-java-model-big.xmi";
    public static final String REFERENCE_STATE_MACHINE = "reference-statemachine.xmi";

    public static void run(String path, String javaModel, String referenceModel, boolean saveResult) {
        System.out.println("Loading Java2StateMachine transformation system...");
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        TransformationSystem system = resourceSet.getTransformationSystem("java2statemachine.henshin");
        EObject rootPackage = null;
        List compilationUnits = null;
        for (EPackage imported : system.getImports()) {
            if (!"containers".equals(imported.getName())) continue;
            EClass packageClass = (EClass)imported.getEClassifier("Package");
            rootPackage = imported.getEFactoryInstance().create(packageClass);
            EReference ref = (EReference)packageClass.getEStructuralFeature("compilationUnits");
            compilationUnits = (List)rootPackage.eGet((EStructuralFeature)ref);
            break;
        }
        System.out.println("Loading Java input model in '" + javaModel + "'");
        Resource javaResource = resourceSet.getResource(javaModel);
        for (EObject object : javaResource.getContents()) {
            if (!"CompilationUnit".equals(object.eClass().getName())) continue;
            compilationUnits.add(object);
        }
        EGraph graph = InterpreterFactory.INSTANCE.createEGraph();
        graph.addTree(rootPackage);
        System.out.println("Model has " + graph.size() + " objects");
        Engine engine = InterpreterFactory.INSTANCE.createEngine();
        engine.getOptions().put("SORT_VARIABLES", false);
        UnitApplication unitApp = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        unitApp.setEGraph(graph);
        unitApp.setUnit(system.findUnitByName("Start"));
        System.out.println("Generating state machine...");
        long time = System.currentTimeMillis();
        if (!unitApp.execute(null)) {
            throw new AssertionError((Object)"Error transforming model");
        }
        time = System.currentTimeMillis() - time;
        System.out.println("Generation took " + time + "ms.");
        EObject statemachine = (EObject)unitApp.getResultParameterValue("sm");
        if (saveResult) {
            resourceSet.saveObject(statemachine, "generated-statemachine.xmi");
            System.out.println("Saved generated state machine in 'generated-statemachine.xmi'");
        } else {
            ResourceImpl dummyResource = new ResourceImpl();
            dummyResource.getContents().add((Object)statemachine);
        }
        if (referenceModel != null) {
            Resource reference = resourceSet.getResource(REFERENCE_STATE_MACHINE);
            if (EGraphIsomorphyChecker.resourcesAreIsomorphic((Resource)reference, (Resource)statemachine.eResource())) {
                System.out.println("Generated state machine is correct.");
            } else {
                throw new AssertionError((Object)"Generated state machine is not correct!");
            }
        }
    }

    public static void main(String[] args) {
        Java2StateMachine.run(PATH, JAVA_MODEL_SMALL, REFERENCE_STATE_MACHINE, false);
    }
}

