/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.EClassComparator;
import org.eclipse.emf.henshin.diagram.edit.helpers.ModuleEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RuleEditHelper;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.diagram.part.Messages;
import org.eclipse.emf.henshin.diagram.providers.HenshinDiagramColorProvider;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinModelCleaner;
import org.eclipse.emf.henshin.presentation.HenshinIcons;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NodeCreateCommand
extends EditElementCommand {
    private static final ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            return ((EClassifier)element).getName();
        }

        public Image getImage(Object element) {
            return HenshinIcons.ECLASS;
        }
    };
    private final Shell shell = HenshinDiagramEditorPlugin.getInstance().getWorkbench().getDisplay().getActiveShell();

    public NodeCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Rule rule = (Rule)this.getElementToEdit();
        Action action = RuleEditHelper.getDefaultAction(rule);
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        Object type = request.getParameter("eclass_node_type");
        Module module = rule.getModule();
        SingleEClassifierSelectionDialog dialog = null;
        if (type == null) {
            dialog = new SingleEClassifierSelectionDialog(module, action);
            type = dialog.openAndReturnSelection();
        }
        if (!(type instanceof EClass)) {
            return CommandResult.newCancelledCommandResult();
        }
        Node node = rule.createNode((EClass)type);
        View ruleView = RuleEditHelper.findRuleView(rule);
        RootObjectEditHelper.updateRootContainment(ruleView, node);
        if (dialog != null) {
            action = dialog.getAction();
        }
        try {
            node.setAction(action);
            RuleEditHelper.setDefaultAction(rule, action);
        }
        catch (Throwable t) {
            HenshinDiagramEditorPlugin.getInstance().logError("Error setting node action", t);
        }
        HenshinModelCleaner.completeMultiRules((Rule)rule.getRootRule());
        HenshinModelCleaner.cleanRule((Rule)rule.getRootRule());
        this.doConfigure(node, monitor, info);
        request.setNewElement((EObject)node);
        return CommandResult.newOKCommandResult((Object)node);
    }

    protected void doConfigure(Node newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    private final class SingleEClassifierSelectionDialog
    extends ElementListSelectionDialog {
        final Module module;
        private Action action;

        public SingleEClassifierSelectionDialog(Module module, Action action) {
            super(NodeCreateCommand.this.shell, labelProvider);
            this.setMultipleSelection(false);
            this.setBlockOnOpen(true);
            this.setTitle(Messages.SingleEClassifierSelectionDialog_title);
            this.setMessage(Messages.SingleEClassifierSelectionDialog_msg);
            this.module = module;
            this.action = action;
        }

        public final EClassifier openAndReturnSelection() {
            ArrayList<EClassifier> elements = new ArrayList<EClassifier>(ModuleEditHelper.collectAllEClassifiers(this.module, false));
            EClassifier result = null;
            if (elements.size() > 0) {
                Collections.sort(elements, new EClassComparator());
                this.setElements(elements.toArray());
                int returnCode = this.open();
                if (returnCode == 0) {
                    result = (EClassifier)this.getFirstResult();
                }
            }
            return result;
        }

        protected Control createDialogArea(Composite parent) {
            Composite contents = (Composite)super.createDialogArea(parent);
            Group group = new Group(contents, 0);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 3;
            group.setLayoutData((Object)data);
            group.setFont(parent.getFont());
            group.setText("Action");
            group.setLayout((Layout)new GridLayout(2, false));
            this.createLabel("Action Type:", (Composite)group);
            Composite buttons = new Composite((Composite)group, 0);
            buttons.setLayout((Layout)new RowLayout(256));
            Action.Type[] typeArray = Action.Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Action.Type type = typeArray[n2];
                Button button = new Button(buttons, 16);
                button.setText(type.toString());
                button.setForeground(HenshinDiagramColorProvider.getActionColor(new Action(type)));
                if (type == this.action.getType()) {
                    button.setSelection(true);
                }
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        SingleEClassifierSelectionDialog.this.action = new Action(type, SingleEClassifierSelectionDialog.this.action.isMulti(), SingleEClassifierSelectionDialog.this.action.getPath(), SingleEClassifierSelectionDialog.this.action.getFragment());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                ++n2;
            }
            this.createLabel("Multi-node:", (Composite)group);
            final Button multi = new Button((Composite)group, 32);
            multi.setSelection(this.action.isMulti());
            multi.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SingleEClassifierSelectionDialog.this.action = new Action(SingleEClassifierSelectionDialog.this.action.getType(), multi.getSelection(), SingleEClassifierSelectionDialog.this.action.getPath());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.createLabel("Path:", (Composite)group);
            final Text path = new Text((Composite)group, 2052);
            path.setLayoutData((Object)new GridData(768));
            String text = this.action.toString().replaceFirst(this.action.getType().toString(), "");
            if (this.action.isMulti()) {
                text = text.replaceFirst("\\*", "");
            }
            path.setText(text);
            path.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String pathText;
                    String text = SingleEClassifierSelectionDialog.this.action.getType().toString();
                    if (SingleEClassifierSelectionDialog.this.action.isMulti()) {
                        text = String.valueOf(text) + '*';
                    }
                    if ((pathText = path.getText().trim()).length() > 0 && !pathText.startsWith("/") && !pathText.startsWith("#")) {
                        pathText = String.valueOf('/') + pathText;
                    }
                    text = String.valueOf(text) + pathText;
                    if (SingleEClassifierSelectionDialog.this.action.getFragment() != null) {
                        text = String.valueOf(text) + '#' + SingleEClassifierSelectionDialog.this.action.getFragment();
                    }
                    try {
                        SingleEClassifierSelectionDialog.this.action = Action.parse((String)text);
                    }
                    catch (ParseException parseException) {}
                }
            });
            return contents;
        }

        private Label createLabel(String label, Composite grid) {
            Label l = new Label(grid, 0);
            l.setText(label);
            l.setLayoutData((Object)new GridData(32));
            SingleEClassifierSelectionDialog.applyDialogFont((Control)l);
            return l;
        }

        public Action getAction() {
            return this.action;
        }
    }
}

