/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;

public class Tools {
    protected static int[] getGraphSizes(UnitApplication ua) {
        EGraph graph = ua.getEGraph();
        int[] sizes = new int[2];
        sizes[0] = graph.size();
        ua.execute(null);
        sizes[1] = graph.size();
        return sizes;
    }

    @Deprecated
    public static TransformationUnit createTUFromRule(Rule r) {
        return r;
    }

    public static void printMatches(List<Match> ma) {
        System.out.println("matches:");
        for (Match m : ma) {
            System.out.println(m);
            System.out.println("===");
        }
    }

    public static void printGraph(EGraph graph) {
        for (EObject eo : graph) {
            System.out.println(eo);
        }
    }

    public static void printGraph(Graph graph) {
        for (EObject eo : graph.eContents()) {
            System.out.println(eo);
            for (Edge edge : graph.getEdges()) {
                System.out.println("edge: " + edge);
            }
        }
    }

    public static void persist(EObject rootObject, String filename) throws IOException {
        ModelUtils.save((EObject)rootObject, (String)filename);
    }

    public static void persist(Rule rule, String filename) throws IOException {
        ResourceSetImpl rSet = new ResourceSetImpl();
        URI myURI = URI.createFileURI((String)filename);
        Resource res = rSet.createResource(myURI, "henshin");
        res.getContents().add((Object)rule);
        res.save(null);
    }

    public static Collection<? extends EObject> getOCLQueryResults(String contextFreeOclQuery, EGraph graph) {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        return result.getEObjects();
    }

    public static EObject getFirstElementFromOCLQueryResult(String contextFreeOclQuery, EGraph graph) {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        if (result.size() == 0) {
            return null;
        }
        return result.getEObjects().toArray(new EObject[1])[0];
    }

    public static EObject getGraphRoot(EGraph graph) {
        return graph.getRoots().toArray(new EObject[1])[0];
    }

    public static void printCollection(Collection<? extends EObject> coll) {
        System.out.println("-------");
        for (EObject eObject : coll) {
            System.out.println(eObject);
        }
        System.out.println("-------");
    }

    public static void printParameterMappings(RuleApplication ra) {
        System.out.println("Input parameters:\n" + ra.getAssignment());
        System.out.println("Output parameters:\n" + ra.getResultAssignment());
    }

    public static Map<Parameter, Object> createParameterMapping(Map<String, Object> mapping, Rule rule) {
        HashMap<Parameter, Object> pMapping = new HashMap<Parameter, Object>();
        for (Parameter param : rule.getParameters()) {
            if (mapping.get(param.getName()) == null) continue;
            pMapping.put(param, mapping.get(param.getName()));
        }
        return pMapping;
    }

    public static void printParameterMappings(UnitApplication ua) {
        System.out.println(ua.getAssignment());
    }
}

