/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.genmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.IItemJavaElementSourceContributor;
import org.eclipse.emf.mint.IJavaElementNotification;
import org.eclipse.emf.mint.MintCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelItemProviderAdapter
extends AdapterImpl
implements IChangeNotifier,
IDisposable,
IItemJavaElementSource,
IExtensionChangeHandler {
    protected final AdapterFactory adapterFactory;
    private final ExtensionTracker extensionTracker;
    private final HashSet<IItemJavaElementSourceContributor> contributors = new HashSet();
    private final HashSet<IExtension> newExtensions = new HashSet();
    protected IChangeNotifier changeNotifier;
    protected List<Notifier> targets;

    public GenModelItemProviderAdapter(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.extensionTracker = new ExtensionTracker(registry);
        IExtensionPoint xpt = registry.getExtensionPoint("org.eclipse.emf.mint", "itemJavaElementSourceContributors");
        this.extensionTracker.registerHandler((IExtensionChangeHandler)this, this.getExtensionPointFilter(xpt));
        this.addExtensions(xpt);
    }

    private synchronized void addExtensions(IExtensionPoint xpt) {
        IExtension[] iExtensionArray = xpt.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            this.newExtensions.add(ext);
            ++n2;
        }
    }

    private IFilter getExtensionPointFilter(IExtensionPoint xpt) {
        return ExtensionTracker.createExtensionPointFilter((IExtensionPoint)xpt);
    }

    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected AdapterFactory getRootAdapterFactory() {
        if (this.adapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void addListener(INotifyChangedListener listener) {
        if (this.changeNotifier == null) {
            this.changeNotifier = new ChangeNotifier();
        }
        this.changeNotifier.addListener(listener);
    }

    public void removeListener(INotifyChangedListener listener) {
        if (this.changeNotifier != null) {
            this.changeNotifier.removeListener(listener);
        }
    }

    public void fireNotifyChanged(Notification notification) {
        if (this.changeNotifier != null) {
            this.changeNotifier.fireNotifyChanged(notification);
        }
        if (this.adapterFactory instanceof IChangeNotifier) {
            IChangeNotifier changeNotifier = (IChangeNotifier)this.adapterFactory;
            changeNotifier.fireNotifyChanged(notification);
        }
    }

    @Override
    public List<IItemJavaElementDescriptor> getJavaElementDescriptors(Object object) {
        LinkedList<IItemJavaElementDescriptor> descriptors = new LinkedList<IItemJavaElementDescriptor>();
        Collection<IItemJavaElementSource> sources = this.getSources(object);
        for (IItemJavaElementSource source : sources) {
            descriptors.addAll(source.getJavaElementDescriptors(object));
        }
        return descriptors;
    }

    protected Collection<IItemJavaElementSource> getSources(Object object) {
        LinkedList<IItemJavaElementSource> sources = new LinkedList<IItemJavaElementSource>();
        Collection<IItemJavaElementSourceContributor> contributors = this.getContributors();
        for (IItemJavaElementSourceContributor contributor : contributors) {
            IItemJavaElementSource source = contributor.getItemJavaElementSource(object);
            if (source == null) continue;
            sources.add(source);
        }
        return sources;
    }

    protected synchronized Collection<IItemJavaElementSourceContributor> getContributors() {
        for (IExtension extension : this.newExtensions) {
            this.loadExtension(extension);
        }
        this.newExtensions.clear();
        return new ArrayList<IItemJavaElementSourceContributor>(this.contributors);
    }

    private void loadExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IConfigurationElement config = iConfigurationElementArray[n2];
                String uri = config.getAttribute("uri");
                if (uri == null || uri.equals("http://www.eclipse.org/emf/2002/GenModel")) {
                    Object obj;
                    try {
                        obj = config.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        MintCore.getInstance().logError("Could not instantiate contributor " + config.getAttribute("class") + ".", e);
                        break block7;
                    }
                    if (!(obj instanceof IItemJavaElementSourceContributor)) {
                        String msg = "Invalid contributor " + (obj == null ? "null" : obj.getClass()) + ".";
                        MintCore.getInstance().logError(msg, null);
                    } else {
                        IItemJavaElementSourceContributor contributor = (IItemJavaElementSourceContributor)obj;
                        if (contributor instanceof IChangeNotifier) {
                            ((IChangeNotifier)contributor).addListener(new INotifyChangedListener(){

                                public void notifyChanged(Notification notification) {
                                    GenModelItemProviderAdapter.this.fireNotifyChanged(notification);
                                }
                            });
                        }
                        this.contributors.add(contributor);
                        this.extensionTracker.registerObject(extension, obj, 2);
                    }
                }
            }
            ++n2;
        }
    }

    public synchronized void addExtension(IExtensionTracker tracker, IExtension extension) {
        if (this.newExtensions.add(extension)) {
            this.fireNotifyChanged(GenModelItemProviderAdapter.createRefreshNotification());
        }
    }

    public synchronized void removeExtension(IExtension extension, Object[] objects) {
        boolean notify;
        if (!this.newExtensions.remove(extension) && this.contributors.removeAll(Arrays.asList(objects))) {
            notify = true;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IDisposable) {
                    ((IDisposable)object).dispose();
                }
                ++n2;
            }
        } else {
            notify = false;
        }
        if (notify) {
            this.fireNotifyChanged(GenModelItemProviderAdapter.createRefreshNotification());
        }
    }

    public void setTarget(Notifier target) {
        if (this.target != null) {
            if (this.target != target) {
                if (this.targets == null) {
                    this.targets = new ArrayList<Notifier>();
                }
                this.targets.add(this.target);
                super.setTarget(target);
            }
        } else {
            super.setTarget(target);
        }
    }

    public void unsetTarget(Notifier target) {
        if (target == this.target) {
            if (this.targets == null || this.targets.isEmpty()) {
                super.setTarget(null);
            } else {
                super.setTarget(this.targets.remove(this.targets.size() - 1));
            }
        } else if (this.targets != null) {
            this.targets.remove(target);
        }
    }

    public void dispose() {
        Notifier oldTarget = this.target;
        this.target = null;
        List<Notifier> oldTargets = this.targets;
        this.targets = null;
        if (oldTarget != null) {
            oldTarget.eAdapters().remove((Object)this);
        }
        if (oldTargets != null) {
            for (Notifier otherTarget : oldTargets) {
                otherTarget.eAdapters().remove((Object)this);
            }
        }
        this.extensionTracker.close();
        this.disposeContributors();
    }

    private synchronized void disposeContributors() {
        for (IItemJavaElementSourceContributor contributor : this.contributors) {
            if (!(contributor instanceof IDisposable)) continue;
            ((IDisposable)contributor).dispose();
        }
    }

    private static Notification createRefreshNotification() {
        return new RefreshNotification();
    }

    private static class RefreshNotification
    extends NotificationImpl
    implements IJavaElementNotification {
        public RefreshNotification() {
            super(10, false, false);
        }

        public Object getElement() {
            return null;
        }
    }
}

