/*******************************************************************************
 * Copyright (c) 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;

public class CleanGeneratedRefactoringContribution extends RefactoringContribution {
	
	@SuppressWarnings("rawtypes")
	@Override
	public RefactoringDescriptor createDescriptor(String id, String project,
			String description, String comment, Map arguments, int flags)
			throws IllegalArgumentException {
		String elementCount = (String) arguments.get("elements");
		if (elementCount == null)
			throw new IllegalArgumentException();
		
		int n;
		try {
			n = Integer.parseInt(elementCount);
		} catch (NumberFormatException e) {
			throw new IllegalArgumentException();
		}
		
		ArrayList<EObject> elements = new ArrayList<EObject>(n);
		ResourceSet rs = new ResourceSetImpl();
		
		for (int i = 1; i <= n; ++i) {
			String uri = (String) arguments.get("element" + i);
			if (uri == null)
				continue;
		
			EObject element;
			try {
				element = rs.getEObject(URI.createURI(uri), true);
			} catch (RuntimeException e) {
				continue;
			}
			
			if (element != null)
				elements.add(element);
		}
		
		return new CleanGeneratedRefactoringDescriptor(elements.toArray());
	}
	
	@Override
	public Map<?, ?> retrieveArgumentMap(RefactoringDescriptor descriptor) {
		Properties args = new Properties();
		Object[] elements = ((CleanGeneratedRefactoringDescriptor) descriptor).getElements();
		int i = 0;
		for (Object element : elements) {
			element = AdapterFactoryEditingDomain.unwrap(element);
			if (element instanceof EObject) {
				URI uri = EcoreUtil.getURI((EObject) element);
				args.setProperty("element" + (++i), uri.toString());
			}
		}
		
		args.setProperty("elements", String.valueOf(i));
		return args;
	}
}
