/*******************************************************************************
 * Copyright (c) 2009 - 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CleanGeneratedWizard extends RefactoringWizard {

	public CleanGeneratedWizard(CleanGeneratedRefactoring refactoring) {
		super(refactoring, DIALOG_BASED_USER_INTERFACE);
		setWindowTitle("Clean Generated Artifacts");
	}

	@Override
	protected void addUserInputPages() {
//		addPage(new OptionsPage("options"));
	}
	
	protected static class OptionsPage extends UserInputWizardPage {

		public OptionsPage(String name) {
			super(name);
			setTitle("Options");
		}

		public void createControl(Composite parent) {
			Composite composite = new Composite(parent, SWT.NONE);
			composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
			composite.setLayout(new GridLayout());
			
			Button includeChildrenBtn = new Button(composite, SWT.CHECK);
			includeChildrenBtn.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
			includeChildrenBtn.setText("Include contained descendants of the selected objects");
			// TODO use dialog settings
			includeChildrenBtn.setSelection(true);
			
			Label noteLabel = new Label(composite, SWT.WRAP);
			noteLabel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
			noteLabel.setText("Note: In most cases, Java elements generated for a given model object" +
					" contain those that are generated for its descendants.");
			
			setControl(composite);
		}
	}
}
