/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.mint.IJavaElementNotification;

/**
 * Default implementation of {@link IJavaElementNotification}.
 * 
 * <p>
 * Clients may extend or instantiate this class.
 * </p>
 */
public class JavaElementNotification extends NotificationWrapper implements
		IJavaElementNotification {

	private final Object element;

	/**
	 * Creates an instance wrapping the original Ecore notification and no model
	 * element.
	 * 
	 * @param notification
	 *            Ecore notification to wrap
	 */
	public JavaElementNotification(Notification notification) {
		this(notification, null);
	}

	/**
	 * Creates an instance wrapping the original Ecore notification and a model
	 * element whose corresponding Java elements (may) have changed.
	 * 
	 * @param notification
	 *            Ecore notification to wrap
	 * @param element
	 *            model element whose corresponding Java elements changed
	 */
	public JavaElementNotification(Notification notification, Object element) {
		super(notification);
		this.element = element;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.mint.IJavaElementNotification#getElement()
	 */
	public Object getElement() {
		return element;
	}
}
