/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.AbstractProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginProjectEditor
extends ProjectEditor
implements IPluginProjectEditor {
    private Document pluginXML;
    private IFile pluginFile;
    private Element pluginRoot;

    public PluginProjectEditor(IProject project) throws ParserConfigurationException, SAXException, IOException, CoreException {
        super(project);
    }

    PluginProjectEditor(AbstractProjectEditor master) {
        super(master);
    }

    @Override
    public void init() {
        this.pluginFile = this.getPlugin();
        if (this.pluginFile != null && this.pluginFile.exists()) {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                this.pluginXML = documentBuilder.parse(this.pluginFile.getLocation().toFile());
                this.pluginRoot = this.pluginXML.getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SAXException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public void createFiles(Set<String> files) {
        IFile plugin;
        if (files.contains("plugin.xml") && !(plugin = this.getProject().getFile("plugin.xml")).exists()) {
            InputStream is = this.getInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>\n");
            try {
                plugin.create(is, true, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        super.createFiles(files);
    }

    @Override
    public boolean exists() {
        IFile plugin = this.getProject().getFile("plugin.xml");
        return plugin.exists() && super.exists();
    }

    @Override
    public Element addExtension(String extensionPoint) {
        if (this.exists()) {
            this.touch();
            Element extension = this.pluginXML.createElement("extension");
            extension.setAttribute("point", extensionPoint);
            this.pluginRoot.appendChild(extension);
            return extension;
        }
        return null;
    }

    @Override
    public List<Node> getExtensions(String extensionPoint) {
        if (this.exists()) {
            NodeList nodes = this.pluginRoot.getChildNodes();
            ArrayList<Node> extensions = new ArrayList<Node>();
            int i = 0;
            while (i < nodes.getLength()) {
                NamedNodeMap attributes;
                Node point;
                String name;
                Node item = nodes.item(i);
                if (item instanceof NodeList && (name = item.getNodeName()).equals("extension") && extensionPoint.equals((point = (attributes = item.getAttributes()).getNamedItem("point")).getNodeValue()) && item instanceof Node) {
                    extensions.add(item);
                }
                ++i;
            }
            return extensions;
        }
        return null;
    }

    @Override
    public void setAttribute(Element element, String attributeName, String attributeValue) {
        if (!Objects.equals(element.getAttribute(attributeName), attributeValue)) {
            this.touch();
            element.setAttribute(attributeName, attributeValue);
        }
    }

    @Override
    public Element addChild(Element element, String childName) {
        this.touch();
        Element child = this.pluginXML.createElement(childName);
        element.appendChild(child);
        return child;
    }

    private IFile getPlugin() {
        IFile plugin = this.getProject().getFile("plugin.xml");
        if (plugin.exists()) {
            return plugin;
        }
        return null;
    }

    @Override
    protected void doSave() {
        if (this.exists()) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(this.pluginXML);
                transformer.transform(source, result);
                Object resultAsString = result.getWriter().toString();
                if (!((String)resultAsString).endsWith("\n")) {
                    resultAsString = (String)resultAsString + "\n";
                }
                InputStream inputStream = this.getInputStream((String)resultAsString);
                this.pluginFile.setContents(inputStream, true, true, null);
            }
            catch (TransformerException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        super.doSave();
    }

    @Override
    public Set<String> getMissingNature() {
        Set<String> natures = super.getMissingNature();
        if (!this.hasNature("org.eclipse.pde.PluginNature")) {
            natures.add("org.eclipse.pde.PluginNature");
        }
        return natures;
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        IFile plugin = this.getProject().getFile("plugin.xml");
        if (!plugin.exists()) {
            files.add("plugin.xml");
        }
        return files;
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        Set<String> commands = super.getMissingBuildCommand();
        if (!this.hasBuildCommand("org.eclipse.pde.SchemaBuilder")) {
            commands.add("org.eclipse.pde.SchemaBuilder");
        }
        return commands;
    }

    @Override
    public Document getDocument() {
        return this.pluginXML;
    }
}

