/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.utils;

import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.swt.graphics.Image;

public class ImageProvider {
    private static ImageProvider instance;
    private static final String QUERY_SET_ICON_PATH = "/icons/querySet.gif";
    private static final String FACET_ICON_PATH = "/icons/facet.gif";
    private static final String FLAT_VIEW_ICON_PATH = "/icons/flatView.gif";
    private static final String TREE_VIEW_ICON_PATH = "/icons/treeView.gif";
    private Image facetIcon;
    private Image queryIcon;
    private Image flatViewIcon;
    private Image treeViewIcon;

    public static ImageProvider getInstance() {
        if (instance == null) {
            instance = new ImageProvider();
        }
        return instance;
    }

    private static ImageDescriptor createImageDescriptor(String resourcePath) {
        URL url = Activator.getDefault().getBundle().getResource(resourcePath);
        if (url == null) {
            Logger.logError((String)NLS.bind((String)"Resource not found: {0}", (Object)resourcePath), (Plugin)Activator.getDefault());
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public Image getFacetIcon() {
        if (this.facetIcon == null) {
            this.facetIcon = ImageProvider.createImageDescriptor(FACET_ICON_PATH).createImage();
        }
        return this.facetIcon;
    }

    public static ImageDescriptor getFacetIconDescriptor() {
        return ImageProvider.createImageDescriptor(FACET_ICON_PATH);
    }

    public Image getQuerySetIcon() {
        if (this.queryIcon == null) {
            this.queryIcon = ImageProvider.createImageDescriptor(QUERY_SET_ICON_PATH).createImage();
        }
        return this.queryIcon;
    }

    public Image getFlatViewIcon() {
        if (this.flatViewIcon == null) {
            this.flatViewIcon = ImageProvider.createImageDescriptor(FLAT_VIEW_ICON_PATH).createImage();
        }
        return this.flatViewIcon;
    }

    public Image getTreeViewIcon() {
        if (this.treeViewIcon == null) {
            this.treeViewIcon = ImageProvider.createImageDescriptor(TREE_VIEW_ICON_PATH).createImage();
        }
        return this.treeViewIcon;
    }
}

