/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactStateInvariantEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLFactory;

public class CutAndInsertOccurrenceSpecificationCompactLifelineCommand
extends AbstractTransactionalCommand {
    private final CompactStateInvariantEditPartCN compactStateInvariantEditPartCN;
    private final Point location;
    private final CompactLifelineEditPartCN lifelineEditPart;
    private final Lifeline lifeline;
    private final boolean destruction;

    public CutAndInsertOccurrenceSpecificationCompactLifelineCommand(CompactStateInvariantEditPartCN compactStateInvariantEditPartCN, Point location, boolean destruction) {
        super(CutAndInsertOccurrenceSpecificationCompactLifelineCommand.getEditingDomain(compactStateInvariantEditPartCN), Messages.CutAndInsertOccurrenceSpecificationCompactLifelineCommand_CreateOccurrenceSpecification, null);
        this.compactStateInvariantEditPartCN = compactStateInvariantEditPartCN;
        this.location = location;
        this.destruction = destruction;
        this.lifelineEditPart = (CompactLifelineEditPartCN)EditPartUtils.findParentEditPartWithId((EditPart)this.compactStateInvariantEditPartCN, "Lifeline_CompactShape");
        this.lifeline = (Lifeline)((View)this.lifelineEditPart.getModel()).getElement();
    }

    private static TransactionalEditingDomain getEditingDomain(CompactStateInvariantEditPartCN compactStateInvariantEditPart) {
        StateInvariant stateInvariant = (StateInvariant)((View)compactStateInvariantEditPart.getModel()).getElement();
        return TransactionUtil.getEditingDomain((EObject)stateInvariant);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int insertionIndexInCoveredBys;
        int insertionIndexInFragments;
        final CompactLifelineCompartmentEditPartCN timelineCompartmentEditPart = (CompactLifelineCompartmentEditPartCN)EditPartUtils.findFirstChildEditPartWithId((EditPart)this.lifelineEditPart, "Lifeline_CompactSubfragmentCompartment");
        View timelineCompartmentView = (View)timelineCompartmentEditPart.getModel();
        Point pt = new Point(this.location);
        timelineCompartmentEditPart.getFigure().translateToRelative((Translatable)pt);
        pt.translate(timelineCompartmentEditPart.getFigure().getBounds().getTopLeft().getNegated());
        int insertionIndexInCompartment = OccurrenceSpecificationUtils.findInsertionIndexFor(pt, timelineCompartmentView, timelineCompartmentEditPart.getViewer());
        if (insertionIndexInCompartment < timelineCompartmentView.getChildren().size()) {
            View view = (View)timelineCompartmentView.getChildren().get(insertionIndexInCompartment);
            EObject element = view.getElement();
            insertionIndexInFragments = this.lifeline.getInteraction().getFragments().indexOf((Object)element);
            insertionIndexInCoveredBys = this.lifeline.getCoveredBys().indexOf((Object)element);
        } else {
            insertionIndexInFragments = -1;
            insertionIndexInCoveredBys = -1;
        }
        DestructionOccurrenceSpecification newOccurrenceSpecification = this.destruction ? UMLFactory.eINSTANCE.createDestructionOccurrenceSpecification() : UMLFactory.eINSTANCE.createOccurrenceSpecification();
        OccurrenceSpecificationUtils.setAutogeneratedName((OccurrenceSpecification)newOccurrenceSpecification, true);
        if (insertionIndexInFragments == -1) {
            this.lifeline.getInteraction().getFragments().add((Object)newOccurrenceSpecification);
        } else {
            this.lifeline.getInteraction().getFragments().add(insertionIndexInFragments, (Object)newOccurrenceSpecification);
        }
        if (insertionIndexInCoveredBys == -1) {
            this.lifeline.getCoveredBys().add((Object)newOccurrenceSpecification);
        } else {
            this.lifeline.getCoveredBys().add(insertionIndexInCoveredBys, (Object)newOccurrenceSpecification);
        }
        UMLViewProvider umlViewProvider = new UMLViewProvider();
        final Node occurrenceSpecificationView = this.destruction ? umlViewProvider.createDestructionOccurrenceSpecification_Shape((EObject)newOccurrenceSpecification, timelineCompartmentView, insertionIndexInCompartment, true, PreferencesHint.USE_DEFAULTS) : umlViewProvider.createOccurrenceSpecification_Shape((EObject)newOccurrenceSpecification, timelineCompartmentView, insertionIndexInCompartment, true, PreferencesHint.USE_DEFAULTS);
        Location loc = NotationFactory.eINSTANCE.createLocation();
        loc.setX(pt.x);
        loc.setY(pt.y);
        occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
        if (this.destruction) {
            OccurrenceSpecificationUtils.deleteEverythingAfter((OccurrenceSpecification)newOccurrenceSpecification, (View)occurrenceSpecificationView);
        } else {
            if (insertionIndexInFragments != -1) {
                ++insertionIndexInFragments;
            }
            if (insertionIndexInCoveredBys != -1) {
                ++insertionIndexInCoveredBys;
            }
            if (insertionIndexInCompartment != -1) {
                ++insertionIndexInCompartment;
            }
            StateInvariantUtils.createCompactStateInvariant(timelineCompartmentView, insertionIndexInFragments, insertionIndexInCoveredBys, insertionIndexInCompartment);
        }
        LifelineUtils.updateFragmentNames(this.lifeline, null);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                timelineCompartmentEditPart.refresh();
                ViewUtils.selectInViewer((View)occurrenceSpecificationView, CutAndInsertOccurrenceSpecificationCompactLifelineCommand.this.lifelineEditPart.getViewer());
            }
        });
        return CommandResult.newOKCommandResult((Object)newOccurrenceSpecification);
    }
}

