/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.core.sashwindows.fulleditor.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class MultiTextEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;
    private Action sampleAction;

    public MultiTextEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.updateActionBars();
        }
    }

    private void createActions() {
        this.sampleAction = new Action(){

            public void run() {
                MessageDialog.openInformation(null, (String)"Editor Plug-in", (String)"Sample Action Executed");
            }
        };
        this.sampleAction.setText("Sample Action");
        this.sampleAction.setToolTipText("Sample Action tool tip");
        this.sampleAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK"));
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("Editor &Menu");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.sampleAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sampleAction);
    }
}

