/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.controlmode.commands;

import java.util.Locale;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.RemoveControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;

public class RemovePropertiesControlResourceCommand
extends RemoveControlResourceCommand {
    private Resource resourceToRemove;
    private Locale locale;
    private InternationalizationModelResource internationalizationModelResource;

    public RemovePropertiesControlResourceCommand(ControlModeRequest request, String fileExtension, Resource resourceToRemove, Locale locale) {
        super(request, fileExtension);
        this.resourceToRemove = resourceToRemove;
        this.locale = locale;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult commandResult = null;
        EObject objectToControl = this.getRequest().getTargetObject();
        if (objectToControl == null) {
            commandResult = CommandResult.newErrorCommandResult((String)CONTROL_OBJECT_ERROR);
        } else {
            ModelSet modelSet = this.getRequest().getModelSet();
            if (modelSet == null) {
                commandResult = CommandResult.newErrorCommandResult((String)RESOURCESET_ERROR);
            } else {
                modelSet.getResourcesToDeleteOnSave().add(this.resourceToRemove.getURI());
                Resource targetResource = this.getTargetResource(objectToControl);
                if (targetResource == null) {
                    commandResult = CommandResult.newErrorCommandResult((String)Messages.getString((String)TARGET_RESOURCE_ERROR, (Object[])new Object[]{this.getFileExtension()}));
                } else {
                    targetResource.setModified(true);
                    this.getRequest().setTargetResource(targetResource, this.getFileExtension());
                    this.getRequest().setSourceResource(this.resourceToRemove, this.getFileExtension());
                    modelSet.getResources().remove((Object)this.resourceToRemove);
                    InternationalizationModelResource modelResource = this.getInternationalizationModelResource();
                    if (modelResource != null) {
                        modelResource.unload(this.resourceToRemove.getURI());
                        modelResource.getResources().remove(this.resourceToRemove);
                    }
                    commandResult = CommandResult.newOKCommandResult();
                }
            }
        }
        return commandResult;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus result = super.doUndo(monitor, info);
        InternationalizationModelResource modelResource = this.getInternationalizationModelResource();
        if (modelResource != null) {
            modelResource.addResourceToModel(this.getRequest().getSourceURI().trimFileExtension(), this.resourceToRemove, this.locale);
        }
        return result;
    }

    protected Resource getSourceResource() {
        return this.resourceToRemove;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus result = super.doRedo(monitor, info);
        InternationalizationModelResource modelResource = this.getInternationalizationModelResource();
        if (modelResource != null) {
            modelResource.unload(this.resourceToRemove.getURI());
            modelResource.getResources().remove(this.resourceToRemove);
        }
        return result;
    }

    protected Resource getTargetResource(EObject objectToUncontrol) {
        InternationalizationModelResource modelResource;
        Resource resultResource = null;
        URI targetURI = null;
        if (objectToUncontrol != null) {
            targetURI = objectToUncontrol.eResource().getURI().trimFileExtension();
            if (this.locale != null) {
                Object lastSegment = targetURI.lastSegment();
                lastSegment = (String)lastSegment + "_" + this.locale.toString();
                targetURI = targetURI.trimSegments(1).appendSegment((String)lastSegment);
            }
            targetURI = targetURI.appendFileExtension(this.getFileExtension());
        }
        if (targetURI != null && (modelResource = this.getInternationalizationModelResource()) != null) {
            resultResource = modelResource.getResourceForURIAndLocale(objectToUncontrol.eResource().getURI().trimFileExtension().appendFileExtension(this.getFileExtension()), this.locale);
        }
        return resultResource;
    }

    protected InternationalizationModelResource getInternationalizationModelResource() {
        ModelSet modelSet;
        if (this.internationalizationModelResource == null && (modelSet = this.getRequest().getModelSet()) != null) {
            try {
                this.internationalizationModelResource = (InternationalizationModelResource)modelSet.getModelChecked("org.eclipse.papyrus.infra.internationalization.resource.InternationalizationModel");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return this.internationalizationModelResource;
    }

    public void dispose() {
        this.internationalizationModelResource = null;
        this.resourceToRemove = null;
        this.locale = null;
        super.dispose();
    }
}

