/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.painter.ResourceHelper;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class RichTextEditorConfiguration {
    public static final String DEFAULT_LANGUAGE = "defaultLanguage";
    public static final String LANGUAGE = "language";
    public static final String TOOLBAR_GROUPS = "toolbarGroups";
    public static final String REMOVE_BUTTONS = "removeButtons";
    public static final String TOOLBAR_CAN_COLLAPSE = "toolbarCanCollapse";
    public static final String TOOLBAR_STARTUP_EXPANDED = "toolbarStartupExpanded";
    public static final String REMOVE_PLUGINS = "removePlugins";
    public static final String RESIZE_ENABLED = "resize_enabled";
    public static final String RESIZE_DIR = "resize_dir";
    public static final String RESIZE_MINWIDTH = "resize_minWidth";
    public static final String RESIZE_MINHEIGHT = "resize_minHeight";
    public static final Collection<String> SUPPORTED_LANGUAGES;
    private static URL resourceURL;
    private boolean removePasteText = true;
    private boolean removePasteFromWord = true;
    private boolean removeStyles = true;
    private boolean removeFormat = true;
    private boolean autoUrlFormattingDisabled = false;
    private Set<String> removedButtons = new HashSet<String>();
    private Browser browser;
    private Set<ToolbarButton> customButtons = new LinkedHashSet<ToolbarButton>();
    private Map<String, BrowserFunction> buttonCallbacks = new HashMap<String, BrowserFunction>();
    private Map<String, Object> options = new HashMap<String, Object>();

    static {
        File directory;
        File[] files;
        SUPPORTED_LANGUAGES = new HashSet<String>();
        resourceURL = RichTextEditorConfiguration.class.getClassLoader().getResource("org/eclipse/nebula/widgets/richtext/resources/ckeditor/lang");
        Bundle bundle = FrameworkUtil.getBundle(RichTextEditor.class);
        if (bundle != null) {
            try {
                resourceURL = FileLocator.toFileURL((URL)resourceURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (resourceURL.toString().startsWith("jar")) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    resourceURL = ResourceHelper.getRichTextResource("ckeditor/lang");
                }
            });
        }
        if ((files = (directory = new File(resourceURL.getFile())).listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                SUPPORTED_LANGUAGES.add(file.getName().substring(0, file.getName().indexOf(46)));
                ++n2;
            }
        }
    }

    public RichTextEditorConfiguration() {
        this.options.put(DEFAULT_LANGUAGE, Locale.ENGLISH.getLanguage());
        this.options.put(LANGUAGE, this.getSupportedLanguage(Locale.getDefault()));
        this.options.put(REMOVE_PLUGINS, "elementspath");
        this.options.put(RESIZE_ENABLED, Boolean.FALSE);
        this.options.put(TOOLBAR_GROUPS, "[{ name: 'clipboard', groups: [ 'clipboard', 'undo', 'find' ] },{ name: 'other' },'/',{ name: 'paragraph', groups: [ 'list', 'indent', 'align' ] },{ name: 'colors' },'/',{ name: 'styles' },{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] }]");
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    @Deprecated
    public RichTextEditorConfiguration(ToolbarConfiguration config) {
        this();
        this.removePasteText = config.removePasteText;
        this.removePasteFromWord = config.removePasteFromWord;
        this.removeStyles = config.removeStyles;
        this.removeFormat = config.removeFormat;
        this.removedButtons.addAll(config.getRemovedButtons());
        this.setToolbarCollapsible(config.toolbarCollapsible);
        this.setToolbarInitialExpanded(config.toolbarInitialExpanded);
        String[] toolbarButtonConfigurations = config.getToolbarButtonConfigurations();
        String tbc = toolbarButtonConfigurations[0];
        tbc = tbc.substring(tbc.indexOf("=") + 1, tbc.length() - 1);
        this.options.put(TOOLBAR_GROUPS, tbc);
        String rbc = toolbarButtonConfigurations[1];
        rbc = rbc.substring(rbc.indexOf("'") + 1, rbc.lastIndexOf("'"));
        this.options.put(REMOVE_BUTTONS, rbc.trim());
        this.customButtons.addAll(config.getCustomButtons());
        this.buttonCallbacks.putAll(config.getButtonCallbacks());
    }

    public void setOption(String key, Object value) {
        this.options.put(key, value);
    }

    public Object getOption(String key) {
        return this.options.get(key);
    }

    public Map<String, Object> getAllOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    private String getSupportedLanguage(Locale locale) {
        if (SUPPORTED_LANGUAGES.isEmpty()) {
            return locale.getLanguage();
        }
        Object localeString = locale.getLanguage();
        if (!locale.getCountry().isEmpty()) {
            localeString = (String)localeString + "-" + locale.getCountry().toLowerCase();
        }
        if (SUPPORTED_LANGUAGES.contains(localeString)) {
            return localeString;
        }
        if (SUPPORTED_LANGUAGES.contains(locale.getLanguage())) {
            return locale.getLanguage();
        }
        return "";
    }

    public void setLanguage(String lang) {
        this.options.put(LANGUAGE, lang);
    }

    public void setLanguage(Locale locale) {
        this.setLanguage(this.getSupportedLanguage(locale));
    }

    public void setDefaultLanguage(String lang) {
        this.options.put(DEFAULT_LANGUAGE, lang);
    }

    public void setDefaultLanguage(Locale locale) {
        String language = this.getSupportedLanguage(locale);
        if (language.isEmpty()) {
            language = "en";
        }
        this.setDefaultLanguage(language);
    }

    public void setResizable(boolean resizable) {
        this.options.put(RESIZE_ENABLED, resizable);
    }

    public void setMinSize(int minWidth, int minHeight) {
        this.options.put(RESIZE_MINWIDTH, minWidth);
        this.options.put(RESIZE_MINHEIGHT, minHeight);
    }

    public void setResizeDirection(String direction) {
        this.options.put(RESIZE_DIR, direction);
    }

    public void setToolbarCollapsible(boolean toolbarCollapsible) {
        this.options.put(TOOLBAR_CAN_COLLAPSE, toolbarCollapsible);
    }

    public void setToolbarInitialExpanded(boolean toolbarInitialExpanded) {
        this.options.put(TOOLBAR_STARTUP_EXPANDED, toolbarInitialExpanded);
    }

    public void setRemovePasteText(boolean removePasteText) {
        this.removePasteText = removePasteText;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void setRemovePasteFromWord(boolean removePasteFromWord) {
        this.removePasteFromWord = removePasteFromWord;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void setRemoveStyles(boolean removeStyles) {
        this.removeStyles = removeStyles;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void setRemoveFormat(boolean removeFormat) {
        this.removeFormat = removeFormat;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void addDefaultToolbarButton(String ... buttonNames) {
        String[] stringArray = buttonNames;
        int n = buttonNames.length;
        int n2 = 0;
        while (n2 < n) {
            String buttonName = stringArray[n2];
            this.removedButtons.remove(buttonName);
            ++n2;
        }
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void removeDefaultToolbarButton(String ... buttonNames) {
        String[] stringArray = buttonNames;
        int n = buttonNames.length;
        int n2 = 0;
        while (n2 < n) {
            String buttonName = stringArray[n2];
            this.removedButtons.add(buttonName);
            ++n2;
        }
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    private String getRemoveButtonConfiguration() {
        StringBuilder builder = new StringBuilder("'Subscript,Superscript");
        if (this.removePasteText) {
            builder.append(",PasteText");
        }
        if (this.removePasteFromWord) {
            builder.append(",PasteFromWord");
        }
        if (this.removeStyles) {
            builder.append(",Styles");
        }
        if (this.removeFormat) {
            builder.append(",Format");
        }
        for (String removed : this.removedButtons) {
            builder.append(",").append(removed);
        }
        builder.append("'");
        return builder.toString();
    }

    protected String getCustomButtonConfiguration() {
        StringBuilder builder = new StringBuilder();
        for (ToolbarButton button : this.customButtons) {
            builder.append("CKEDITOR.instances.editor.addCommand('").append(button.getCommandName()).append("', {");
            builder.append("exec: function(edt) {");
            if (button.getJavascriptToExecute() == null) {
                builder.append("javaExecutionStarted();");
                BrowserFunction function = this.buttonCallbacks.get(button.getCommandName());
                builder.append(function.getName()).append("();");
                builder.append("javaExecutionFinished()");
            } else {
                builder.append(button.getJavascriptToExecute());
            }
            builder.append("}});");
            builder.append("CKEDITOR.instances.editor.ui.addButton('").append(button.getButtonName()).append("', {");
            builder.append("label: '").append(button.getButtonLabel()).append("',");
            builder.append("command: '").append(button.getCommandName()).append("',");
            builder.append("toolbar: '").append(button.getToolbar()).append("',");
            if (button.getIconURL() != null) {
                builder.append("icon: '").append(button.getIconURL().toString()).append("',");
            }
            builder.append("});");
        }
        return builder.toString();
    }

    public void addToolbarButton(final ToolbarButton button) {
        if (this.browser != null) {
            this.addToolbarButton(button, new BrowserFunction(this.browser, button.getCommandName()){

                public Object function(Object[] arguments) {
                    return button.execute();
                }
            });
        } else if (!this.customButtons.contains(button)) {
            this.customButtons.add(button);
        }
    }

    public void addToolbarButton(ToolbarButton button, BrowserFunction function) {
        if (this.buttonCallbacks.containsKey(button.getCommandName())) {
            this.buttonCallbacks.get(button.getCommandName()).dispose();
        }
        this.buttonCallbacks.put(button.getCommandName(), function);
        if (!this.customButtons.contains(button)) {
            this.customButtons.add(button);
        }
        this.removedButtons.remove(button.getButtonName());
    }

    public void removeToolbarButton(ToolbarButton button) {
        this.customButtons.remove(button);
        if (this.buttonCallbacks.containsKey(button.getCommandName())) {
            this.buttonCallbacks.get(button.getCommandName()).dispose();
            this.buttonCallbacks.remove(button.getCommandName());
        }
        this.removedButtons.add(button.getButtonName());
    }

    public void customizeToolbar() {
        this.browser.evaluate(this.getCustomButtonConfiguration());
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
        for (ToolbarButton button : this.customButtons) {
            this.addToolbarButton(button);
        }
    }

    public void dispose() {
        for (BrowserFunction function : this.buttonCallbacks.values()) {
            function.dispose();
        }
    }

    public boolean isAutoUrlFormattingDisabled() {
        return this.autoUrlFormattingDisabled;
    }

    public void setAutoUrlFormattingDisabled(boolean autoUrlFormattingDisabled) {
        this.autoUrlFormattingDisabled = autoUrlFormattingDisabled;
    }
}

