/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.common.utils;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;

public final class SiriusInterpreterHelper {
    public static final String INTEGER_VALUE = "integerValue";
    public static final String REAL_VALUE = "realValue";
    public static final String UNLIMITED_NATURAL_VALUE = "unlimitedNaturalValue";
    public static final String MULTIPLICITY_VALUE = "multiplicityValue";
    private static SiriusInterpreterHelper instance;
    private IInterpreter interpreter;

    private SiriusInterpreterHelper() {
    }

    public static SiriusInterpreterHelper getInstance() {
        if (instance == null) {
            instance = new SiriusInterpreterHelper();
        }
        return instance;
    }

    public IInterpreter getSiriusInterpreter(SiriusInputDescriptor input) {
        if (this.interpreter == null && input != null) {
            this.interpreter = ((Session)input.getFullContext().getSession().get()).getInterpreter();
        }
        return this.interpreter;
    }

    public void clearValidationVariablesFromInterpreter(SiriusInputDescriptor inputDescriptor) {
        IInterpreter siriusInterpreter = this.getSiriusInterpreter(inputDescriptor);
        if (siriusInterpreter != null) {
            this.clearVariableValues(siriusInterpreter, INTEGER_VALUE);
            this.clearVariableValues(siriusInterpreter, REAL_VALUE);
            this.clearVariableValues(siriusInterpreter, UNLIMITED_NATURAL_VALUE);
            this.clearVariableValues(siriusInterpreter, MULTIPLICITY_VALUE);
        }
    }

    private void clearVariableValues(IInterpreter siriusInterpreter, String variableToClear) {
        while (siriusInterpreter.getVariable(variableToClear) != null) {
            siriusInterpreter.unSetVariable(variableToClear);
        }
    }
}

