/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.internal.ui.advice;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.service.types.internal.ui.commands.InstanceSpecificationLinkCreateCommand;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class InstanceSpecificationLinkEditHelperAdvice
extends AbstractEditHelperAdvice {
    private static final String PARAM_SUPPRESS_DIALOG_WITH_VALUE = InstanceSpecificationLinkEditHelperAdvice.class.getName() + ":AssociationSelectionDialogResult";

    public static boolean canCreate(EObject source, EObject target) {
        if (source != null && target == null) {
            return source instanceof InstanceSpecification;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!(source instanceof InstanceSpecification)) {
            return false;
        }
        return target instanceof InstanceSpecification;
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        InstanceSpecification linkToEdit = null;
        InstanceSpecification source = null;
        InstanceSpecification target = null;
        if (request.getElementToConfigure() instanceof InstanceSpecification) {
            linkToEdit = (InstanceSpecification)request.getElementToConfigure();
        }
        if (request.getParameter("CreateRelationshipRequest.source") instanceof InstanceSpecification) {
            source = (InstanceSpecification)request.getParameter("CreateRelationshipRequest.source");
        }
        if (request.getParameter("CreateRelationshipRequest.target") instanceof InstanceSpecification) {
            target = (InstanceSpecification)request.getParameter("CreateRelationshipRequest.target");
        }
        if (source != null && target != null && linkToEdit != null) {
            return new InstanceSpecificationLinkCreateCommand(request);
        }
        return super.getAfterConfigureCommand(request);
    }

    public static boolean shouldSuppressDialog(IEditCommandRequest request) {
        return request.getParameters().containsKey(PARAM_SUPPRESS_DIALOG_WITH_VALUE);
    }

    public static Association getSuppressedDialogResult(IEditCommandRequest request) {
        Object result = request.getParameter(PARAM_SUPPRESS_DIALOG_WITH_VALUE);
        return result == null ? null : (Association)result;
    }

    public static void setupSuppressDialogRequest(CreateConnectionViewRequest request, Association association) {
        request.getExtendedData().put(PARAM_SUPPRESS_DIALOG_WITH_VALUE, association);
    }

    private static HashSet<Association> getInstanceAssociations(InstanceSpecification instance) {
        HashSet<Association> instanceAssociationsSet = new HashSet<Association>();
        for (Classifier classifier : InstanceSpecificationLinkEditHelperAdvice.getSpecificationClassifier(instance)) {
            instanceAssociationsSet.addAll((Collection<Association>)classifier.getAssociations());
        }
        return instanceAssociationsSet;
    }

    public static Set<Classifier> getSpecificationClassifier(InstanceSpecification instance) {
        HashSet<Classifier> specificationClassicfiersSet = new HashSet<Classifier>();
        for (Classifier classifier : instance.getClassifiers()) {
            if (specificationClassicfiersSet.contains(classifier)) continue;
            specificationClassicfiersSet.add(classifier);
            specificationClassicfiersSet.addAll(InstanceSpecificationLinkEditHelperAdvice.getInheritedClassifier(classifier, null));
        }
        return specificationClassicfiersSet;
    }

    private static Set<Classifier> getInheritedClassifier(Classifier classifier, Set<Classifier> alreadyParsedClassifier) {
        HashSet<Classifier> generalizationClassifiers = new HashSet<Classifier>();
        HashSet<Classifier> parsedClassifiersSet = new HashSet<Classifier>();
        if (alreadyParsedClassifier != null) {
            parsedClassifiersSet.addAll(alreadyParsedClassifier);
        }
        if (!parsedClassifiersSet.contains(classifier)) {
            parsedClassifiersSet.add(classifier);
            EList classifierGeneralizations = classifier.parents();
            generalizationClassifiers.addAll((Collection<Classifier>)classifierGeneralizations);
            for (Classifier generalClassifier : classifierGeneralizations) {
                generalizationClassifiers.addAll(InstanceSpecificationLinkEditHelperAdvice.getInheritedClassifier(generalClassifier, parsedClassifiersSet));
            }
        }
        return generalizationClassifiers;
    }

    private static Set<Association> getInstanceAssociations(InstanceSpecification sourceInstance, InstanceSpecification targetInstance) {
        HashSet<Association> instanceAssociationsSet = new HashSet<Association>();
        Iterator<Association> sourceAssociationsIterator = InstanceSpecificationLinkEditHelperAdvice.getInstanceAssociations(sourceInstance).iterator();
        Set<Classifier> sourceClassifiers = InstanceSpecificationLinkEditHelperAdvice.getSpecificationClassifier(sourceInstance);
        Set<Classifier> targetClassifiers = InstanceSpecificationLinkEditHelperAdvice.getSpecificationClassifier(targetInstance);
        while (sourceAssociationsIterator.hasNext()) {
            Association nextAssociation = sourceAssociationsIterator.next();
            if (!InstanceSpecificationLinkEditHelperAdvice.checkAssociationEndType(nextAssociation, sourceClassifiers, targetClassifiers)) continue;
            instanceAssociationsSet.add(nextAssociation);
        }
        return instanceAssociationsSet;
    }

    private static boolean checkAssociationEndType(Association association, Set<Classifier> sourceClassifiers, Set<Classifier> targetClassifiers) {
        if (association.getMemberEnds().size() != 2) {
            return false;
        }
        Type sourceAssociationEnd = ((Property)association.getMemberEnds().get(0)).getType();
        Type targetAssociationEnd = ((Property)association.getMemberEnds().get(1)).getType();
        for (Classifier nextSourceClassifier : sourceClassifiers) {
            for (Classifier nextTargetClassifier : targetClassifiers) {
                if ((nextSourceClassifier != sourceAssociationEnd || nextTargetClassifier != targetAssociationEnd) && (nextSourceClassifier != targetAssociationEnd || nextTargetClassifier != sourceAssociationEnd)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Association> getModelAssociations(InstanceSpecification source, InstanceSpecification target) {
        if (source == null || target == null) {
            return Collections.emptySet();
        }
        return InstanceSpecificationLinkEditHelperAdvice.getInstanceAssociations(source, target);
    }
}

