/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.filter.configuration;

import ca.odell.glazedlists.matchers.Matcher;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.papyrus.infra.nattable.filter.AbstractPapyrusMatcherEditor;
import org.eclipse.papyrus.infra.nattable.filter.AbstractSinglePapyrusMatcher;
import org.eclipse.uml2.uml.EnumerationLiteral;

public class UMLEnumerationMatcherEditor
extends AbstractPapyrusMatcherEditor {
    public UMLEnumerationMatcherEditor(IColumnAccessor<Object> columnAccesor, int columnIndex, Object matchOn, IConfigRegistry configRegistry) {
        super(columnAccesor, columnIndex, matchOn, configRegistry);
    }

    protected Matcher<Object> createMatcher(IColumnAccessor<Object> columnAccesor, int columnIndex, Object matchOn, IConfigRegistry configRegistry) {
        return new UMLEnumerationMatcher(columnAccesor, matchOn, columnIndex, configRegistry);
    }

    public static class UMLEnumerationMatcher
    extends AbstractSinglePapyrusMatcher<Object> {
        public UMLEnumerationMatcher(IColumnAccessor<Object> accessor, Object wantedObject, int columnIndex, IConfigRegistry configRegistry) {
            super(accessor, columnIndex, wantedObject, configRegistry);
        }

        public UMLEnumerationMatcher(IColumnAccessor<Object> accessor, Object wantedObject, int columnIndex) {
            super(accessor, columnIndex, wantedObject);
        }

        public boolean matches(Object item) {
            Object res = this.getColumnAccessor().getDataValue(item, this.getColumnIndex());
            if (res != null) {
                Object wantedObject = this.getObjectToMatch();
                if (res instanceof Collection) {
                    String wantedName = null;
                    if (wantedObject instanceof Enumerator) {
                        wantedName = ((Enumerator)wantedObject).getName();
                    } else if (wantedObject instanceof String) {
                        wantedName = (String)wantedObject;
                    }
                    Assert.isNotNull((Object)wantedName);
                    for (Object tmp : (Collection)res) {
                        EnumerationLiteral lit;
                        if (!(tmp instanceof EnumerationLiteral ? (lit = (EnumerationLiteral)tmp).getName().equals(wantedName) : tmp instanceof String && wantedName.equals(tmp))) continue;
                        return true;
                    }
                    return ((Collection)res).contains(wantedObject);
                }
                if (res instanceof EnumerationLiteral && wantedObject instanceof Enumerator) {
                    return ((EnumerationLiteral)res).getName().equals(((Enumerator)wantedObject).getName());
                }
                if (res instanceof Enumerator && wantedObject instanceof Enumerator) {
                    return ((Enumerator)res).getName().equals(((Enumerator)wantedObject).getName());
                }
                if (res instanceof EnumerationLiteral && wantedObject instanceof String) {
                    return wantedObject.equals(((EnumerationLiteral)res).getName());
                }
                if (res instanceof String && wantedObject instanceof String) {
                    return wantedObject.equals(res);
                }
            }
            return false;
        }
    }
}

