/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractOccurrenceLinkEditHelperAdvice;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class GeneralOrderingHelperAdvice
extends AbstractOccurrenceLinkEditHelperAdvice {
    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        EObject toConfigure;
        CompositeCommand composite = new CompositeCommand("After Configure Command of GeneralOrdering");
        ICommand afterConfigureCommand = super.getAfterConfigureCommand(request);
        if (afterConfigureCommand != null && afterConfigureCommand.canExecute()) {
            composite.compose((IUndoableOperation)afterConfigureCommand);
        }
        if (!((toConfigure = request.getElementToConfigure()) instanceof GeneralOrdering)) {
            return composite;
        }
        final GeneralOrdering generalOrdering = (GeneralOrdering)toConfigure;
        final Element source = this.getSourceElement((AbstractEditCommandRequest)request);
        final Element target = this.getTargetElement((AbstractEditCommandRequest)request);
        if (source instanceof OccurrenceSpecification && target instanceof OccurrenceSpecification) {
            AbstractTransactionalCommand initOrderedElements = new AbstractTransactionalCommand(request.getEditingDomain(), "Init GeneralOrdering ordered elements", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    generalOrdering.setBefore((OccurrenceSpecification)source);
                    generalOrdering.setAfter((OccurrenceSpecification)target);
                    return CommandResult.newOKCommandResult();
                }
            };
            composite.compose((IUndoableOperation)initOrderedElements);
        }
        return composite;
    }

    @Override
    protected Element getCreationContainer(Element targetElement) {
        return this.findInteraction(targetElement);
    }

    protected ICommand getAfterReorientRelationshipCommand(ReorientRelationshipRequest request) {
        EObject relationship = request.getRelationship();
        if (relationship instanceof GeneralOrdering) {
            GeneralOrdering ordering = (GeneralOrdering)relationship;
            EObject newEnd = request.getNewRelationshipEnd();
            if (newEnd instanceof OccurrenceSpecification) {
                SetRequest setRequest = request.getDirection() == 1 ? new SetRequest((EObject)ordering, (EStructuralFeature)UMLPackage.Literals.GENERAL_ORDERING__BEFORE, (Object)newEnd) : new SetRequest((EObject)ordering, (EStructuralFeature)UMLPackage.Literals.GENERAL_ORDERING__AFTER, (Object)newEnd);
                return new SetValueCommand(setRequest);
            }
        }
        return super.getAfterReorientRelationshipCommand(request);
    }

    protected Interaction findInteraction(Element source) {
        Element element = source;
        while (element != null) {
            if (element instanceof Interaction) {
                return (Interaction)element;
            }
            element = element.getOwner();
        }
        return null;
    }
}

