/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.AbstractDecoratorModelUpdater;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.IDecoratorModelUpdaterDelegate;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;

public class PostControlDecoratorModelUpdater
extends AbstractDecoratorModelUpdater {
    private final Map<URI, URI> profilesToAdd;
    private Set<URI> profilesAdded;

    public PostControlDecoratorModelUpdater(IDecoratorModelUpdaterDelegate delegate, PackageRefactoringContext context, URI decoratorModelURI) {
        super(delegate);
        this.profilesToAdd = context.getAllExternalProfileApplicationsFor(decoratorModelURI);
    }

    @Override
    public boolean refactor(Resource resource, IProgressMonitor monitor) throws ExecutionException {
        boolean result = false;
        monitor.beginTask(NLS.bind((String)Messages.PostControlDecoratorModelUpdater_0, (Object)resource.getURI().lastSegment()), -1);
        if (!this.profilesToAdd.isEmpty()) {
            Package evilTwin = this.getDecoratorPackage(resource);
            if (evilTwin == null) {
                evilTwin = this.createDecoratorPackage(resource);
                result = true;
            }
            for (Map.Entry<URI, URI> next : this.profilesToAdd.entrySet()) {
                URI profileURI = next.getKey();
                if (this.hasProfileApplication(evilTwin, profileURI)) continue;
                this.addProfileApplication(evilTwin, profileURI, next.getValue());
                result = true;
                if (this.profilesAdded == null) {
                    this.profilesAdded = Sets.newHashSet();
                }
                this.profilesAdded.add(profileURI);
            }
        }
        return result;
    }

    @Override
    public boolean unrefactor(Resource resource, IProgressMonitor monitor) throws ExecutionException {
        boolean result = false;
        monitor.beginTask(NLS.bind((String)Messages.PostControlDecoratorModelUpdater_1, (Object)resource.getURI().lastSegment()), -1);
        if (this.profilesAdded != null) {
            Package evilTwin = this.getDecoratorPackage(resource);
            if (evilTwin != null) {
                for (URI next : this.profilesAdded) {
                    ProfileApplication application = this.getProfileApplication(evilTwin, next);
                    if (application == null) continue;
                    application.destroy();
                    result = true;
                }
                if (evilTwin.getProfileApplications().isEmpty()) {
                    evilTwin.destroy();
                    result = true;
                }
            }
            this.profilesAdded = null;
        }
        return result;
    }
}

