/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModelListener;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class GroupByModel
extends Observable
implements IPersistable {
    public static final String PERSISTENCE_KEY_GROUP_BY_COLUMN_INDEXES = ".groupByColumnIndexes";
    private List<Integer> groupByColumnIndexes = new ArrayList<Integer>();
    private List<GroupByModelListener> listener = new ArrayList<GroupByModelListener>();

    public boolean addGroupByColumnIndex(int columnIndex) {
        if (!this.groupByColumnIndexes.contains(columnIndex)) {
            this.groupByColumnIndexes.add(columnIndex);
            this.update();
            return true;
        }
        return false;
    }

    public boolean addAllGroupByColumnIndexes(int ... columnIndexes) {
        boolean changed = false;
        int[] nArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (!this.groupByColumnIndexes.contains(index)) {
                this.groupByColumnIndexes.add(index);
                changed = true;
            }
            ++n2;
        }
        if (changed) {
            this.update();
        }
        return changed;
    }

    public void setGroupByColumnIndexes(int ... columnIndexes) {
        this.groupByColumnIndexes.clear();
        this.groupByColumnIndexes.addAll(Arrays.stream(columnIndexes).boxed().collect(Collectors.toList()));
        this.update();
    }

    public boolean removeGroupByColumnIndex(int columnIndex) {
        if (this.groupByColumnIndexes.contains(columnIndex)) {
            this.groupByColumnIndexes.remove((Object)columnIndex);
            this.update();
            return true;
        }
        return false;
    }

    public boolean removeAllGroupByColumnIndexes(int ... columnIndexes) {
        boolean changed = false;
        int[] nArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (this.groupByColumnIndexes.contains(index)) {
                this.groupByColumnIndexes.remove((Object)index);
                changed = true;
            }
            ++n2;
        }
        if (changed) {
            this.update();
        }
        return changed;
    }

    public void clearGroupByColumnIndexes() {
        this.groupByColumnIndexes.clear();
        this.update();
    }

    public List<Integer> getGroupByColumnIndexes() {
        return this.groupByColumnIndexes;
    }

    public void saveState(String prefix, Properties properties) {
        StringBuilder strBuilder = new StringBuilder();
        for (Integer index : this.groupByColumnIndexes) {
            strBuilder.append(index);
            strBuilder.append(",");
        }
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_BY_COLUMN_INDEXES, strBuilder.toString());
    }

    public void loadState(String prefix, Properties properties) {
        this.groupByColumnIndexes.clear();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_BY_COLUMN_INDEXES);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.groupByColumnIndexes.add(Integer.valueOf(index));
            }
        }
        this.update();
    }

    public void update() {
        this.setChanged();
        this.notifyObservers();
        this.fireGroupByModelChange();
    }

    public void addGroupByModelListener(GroupByModelListener listener) {
        this.listener.add(listener);
    }

    public void removeGroupByModelListener(GroupByModelListener listener) {
        this.listener.remove(listener);
    }

    protected void fireGroupByModelChange() {
        this.listener.stream().forEach(l -> l.handleGroupByModelChange(this));
    }
}

