/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;

public class DeleteTimeElementWithoutEventPolicy
extends AbstractEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String KEY = "DeleteTimeElementWithoutEvent";
    protected HashMap<EObject, List<View>> additionalParentToListen = new HashMap();
    protected EObject hostSemanticElement;

    public void activate() {
        View hostView = (View)this.getHost().getModel();
        this.hostSemanticElement = hostView.getElement();
        this.getDiagramEventBroker().addNotificationListener((EObject)hostView, (NotificationListener)this);
        this.getDiagramEventBroker().addNotificationListener(this.hostSemanticElement, (NotificationListener)this);
        for (View linkedView : this.getLinkedViews()) {
            this.getDiagramEventBroker().addNotificationListener(linkedView.eContainer(), (NotificationListener)this);
        }
        super.activate();
    }

    protected void removeAdditionalParentToListen(EObject semanticParent, View childView) {
        if (this.additionalParentToListen.containsKey(semanticParent)) {
            List<View> views = this.additionalParentToListen.get(semanticParent);
            assert (views != null) : "list should not be null";
            views.remove(childView);
            if (views.isEmpty()) {
                this.additionalParentToListen.remove(semanticParent);
                if (!semanticParent.equals(((View)this.getHost().getModel()).getElement())) {
                    this.getDiagramEventBroker().removeNotificationListener(semanticParent, (NotificationListener)this);
                }
            }
        }
    }

    public void deactivate() {
        View hostView = (View)this.getHost().getModel();
        for (EObject parent : this.additionalParentToListen.keySet()) {
            this.getDiagramEventBroker().removeNotificationListener(parent, (NotificationListener)this);
        }
        this.additionalParentToListen.clear();
        this.additionalParentToListen = null;
        this.getDiagramEventBroker().removeNotificationListener((EObject)hostView, (NotificationListener)this);
        this.getDiagramEventBroker().removeNotificationListener(this.hostSemanticElement, (NotificationListener)this);
        this.hostSemanticElement = null;
        super.deactivate();
    }

    protected final void deleteTimeElement() {
        Command cmd = this.getDeleteElementCommand(false);
        if (cmd.canExecute()) {
            this.executeCommand(cmd);
        }
    }

    protected final void deleteTimeView() {
        Command cmd = this.getDeleteElementCommand(true);
        if (cmd.canExecute()) {
            this.executeCommand(cmd);
        }
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ((IGraphicalEditPart)DeleteTimeElementWithoutEventPolicy.this.getHost()).getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
                return Status.OK_STATUS;
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.undo();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected boolean isTimeElementDefined() {
        if (this.hostSemanticElement instanceof TimeObservation) {
            return ((TimeObservation)this.hostSemanticElement).getEvent() != null;
        }
        if (this.hostSemanticElement instanceof DurationObservation) {
            return ((DurationObservation)this.hostSemanticElement).getEvents().size() >= 2;
        }
        if (this.hostSemanticElement instanceof TimeConstraint) {
            return ((TimeConstraint)this.hostSemanticElement).getConstrainedElements().size() > 0;
        }
        return true;
    }

    protected List<View> getLinkedViews() {
        return Collections.emptyList();
    }

    protected Command getDeleteElementCommand(boolean graphOnly) {
        if (graphOnly) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            return new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)this.getHost().getModel()));
        }
        DestroyElementRequest req = new DestroyElementRequest(this.hostSemanticElement, false);
        return this.getDestroyElementCommand(req);
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        ICommand deleteCommand;
        EObject selectedEObject = req.getElementToDestroy();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)selectedEObject);
        if (provider != null && (deleteCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
            return new ICommandProxy(deleteCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier.equals(this.hostSemanticElement)) {
            if (4 == notification.getEventType() || 1 == notification.getEventType()) {
                this.deleteTimeElementIfNeeded();
            }
        } else if (notifier instanceof View && 4 == notification.getEventType()) {
            this.deleteTimeElementIfNeeded();
        }
    }

    protected void removeListenerForView(View oldView) {
        HashMap<EObject, ArrayList<View>> parentsToDelete = new HashMap<EObject, ArrayList<View>>();
        for (EObject parent : this.additionalParentToListen.keySet()) {
            List<View> parentViews = this.additionalParentToListen.get(parent);
            if (!parentViews.contains(oldView)) continue;
            ArrayList<View> views = (ArrayList<View>)parentsToDelete.get(parent);
            if (views == null) {
                views = new ArrayList<View>();
            }
            views.add(oldView);
            parentsToDelete.put(parent, views);
        }
    }

    protected void removeListeners(List<View> impactedViews) {
        HashMap<EObject, ArrayList<View>> parentsToDelete = new HashMap<EObject, ArrayList<View>>();
        for (View view : impactedViews) {
            for (EObject parent : this.additionalParentToListen.keySet()) {
                List<View> parentViews = this.additionalParentToListen.get(parent);
                if (!parentViews.contains(view)) continue;
                ArrayList<View> views = (ArrayList<View>)parentsToDelete.get(parent);
                if (views == null) {
                    views = new ArrayList<View>();
                }
                views.add(view);
                parentsToDelete.put(parent, views);
            }
        }
        for (EObject object : parentsToDelete.keySet()) {
            List views = (List)parentsToDelete.get(object);
            for (View view : views) {
                this.removeAdditionalParentToListen(object, view);
            }
        }
    }

    protected void deleteTimeElementIfNeeded() {
        if (!this.isTimeElementDefined()) {
            this.deleteTimeElement();
        }
    }

    public void forceRefresh() {
        this.deleteTimeElementIfNeeded();
    }
}

