/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;

public class GateLocator
extends AdvancedBorderItemLocator {
    private Integer alignment;

    public GateLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle validLocation = proposedLocation.getCopy();
        Rectangle bounds = this.getParentBorder();
        int alignment = this.getAlignment(proposedLocation);
        if (1 == alignment) {
            validLocation.x = bounds.x - proposedLocation.width / 2;
            if (validLocation.y < bounds.y - proposedLocation.height / 2) {
                validLocation.y = bounds.y - proposedLocation.height / 2;
            } else if (validLocation.y > bounds.bottom() - proposedLocation.height / 2) {
                validLocation.y = bounds.bottom() - proposedLocation.height / 2;
            }
        } else if (4 == alignment) {
            validLocation.x = bounds.right() - proposedLocation.width / 2;
            if (validLocation.y < bounds.y - proposedLocation.height / 2) {
                validLocation.y = bounds.y - proposedLocation.height / 2;
            } else if (validLocation.y > bounds.bottom() - proposedLocation.height / 2) {
                validLocation.y = bounds.bottom() - proposedLocation.height / 2;
            }
        } else if (8 == alignment) {
            validLocation.y = bounds.y - proposedLocation.height / 2;
            if (validLocation.x < bounds.x - proposedLocation.width / 2) {
                validLocation.x = bounds.x - proposedLocation.width / 2;
            } else if (validLocation.x > bounds.right() - proposedLocation.width / 2) {
                validLocation.x = bounds.right() - proposedLocation.width / 2;
            }
        } else {
            validLocation.y = bounds.bottom() - proposedLocation.height / 2;
            if (validLocation.x < bounds.x - proposedLocation.width / 2) {
                validLocation.x = bounds.x - proposedLocation.width / 2;
            } else if (validLocation.x > bounds.right() - proposedLocation.width / 2) {
                validLocation.x = bounds.right() - proposedLocation.width / 2;
            }
        }
        return validLocation;
    }

    public int getAlignment() {
        return this.alignment == null ? 0 : this.alignment;
    }

    public int getAlignment(Rectangle newConstraint) {
        Rectangle modelConstraint;
        if (this.alignment != null && (modelConstraint = this.getModelConstraint()) != null && modelConstraint.equals((Object)newConstraint)) {
            return this.alignment;
        }
        Rectangle parentBounds = this.getParentBorder();
        if (parentBounds.isEmpty()) {
            return 0;
        }
        if (parentBounds.touches(newConstraint)) {
            Point center = newConstraint.getCenter();
            int leftOffset = Math.abs(center.x - parentBounds.x);
            int rightOffset = Math.abs(center.x - parentBounds.right());
            int topOffset = Math.abs(center.y - parentBounds.y);
            int bottomOffset = Math.abs(center.y - parentBounds.bottom());
            int minOffset = Math.min(Math.min(leftOffset, rightOffset), Math.min(topOffset, bottomOffset));
            this.alignment = minOffset == leftOffset ? Integer.valueOf(1) : (minOffset == rightOffset ? Integer.valueOf(4) : (minOffset == topOffset ? Integer.valueOf(8) : Integer.valueOf(32)));
        } else {
            this.alignment = newConstraint.x > parentBounds.x && newConstraint.bottom() < parentBounds.y && newConstraint.right() < parentBounds.right() ? Integer.valueOf(8) : (newConstraint.x > parentBounds.x && newConstraint.y > parentBounds.bottom() && newConstraint.right() < parentBounds.right() ? Integer.valueOf(32) : (newConstraint.right() < parentBounds.x ? Integer.valueOf(1) : Integer.valueOf(4)));
        }
        return this.alignment;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint();
        rectSuggested.setSize(size);
        Rectangle validLocation = this.getValidLocation(rectSuggested, borderItem);
        borderItem.setBounds(validLocation);
    }

    protected Rectangle getModelConstraint() {
        throw new IllegalStateException();
    }
}

