/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.representation.architecture;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorNameInitializer;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.sirius.editor.internal.viewpoint.SiriusDiagramViewPrototype;
import org.eclipse.papyrus.sirius.editor.representation.ICreateSiriusDiagramEditorCommand;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.papyrus.sirius.editor.representation.architecture.AbstractCreateSiriusDiagramEditorCommand;
import org.eclipse.papyrus.sirius.editor.representation.architecture.Activator;
import org.eclipse.papyrus.sirius.editor.representation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDefaultNameProvider;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class CreatePapyrusSiriusActivityDiagramEditorCommand
extends AbstractCreateSiriusDiagramEditorCommand
implements ICreateSiriusDiagramEditorCommand {
    private String askName(ViewPrototype prototype, EObject semanticContext) {
        String defaultName = this.getDefaultName(prototype, semanticContext);
        return this.askDiagramName(Messages.CreatePapyrusSiriusDiagramEditorCommand_CreateSiriusDiagramDialogTitle, defaultName);
    }

    private String getDefaultName(ViewPrototype prototype, EObject semanticContext) {
        StringBuilder nameBuilder = new StringBuilder(prototype.getLabel().replaceAll(" ", ""));
        String nameWithIncrement = EditorNameInitializer.getNameWithIncrement((EClass)DiagramPackage.eINSTANCE.getDDiagram(), (EStructuralFeature)ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Name(), (String)nameBuilder.toString(), (EObject)semanticContext);
        return nameWithIncrement;
    }

    public DSemanticDiagram execute(ViewPrototype prototype, String name, EObject semanticContext, boolean openAfterCreation) {
        return this.execute(prototype, name, semanticContext, semanticContext, openAfterCreation);
    }

    public DSemanticDiagram execute(ViewPrototype prototype, String name, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        if (prototype instanceof SiriusDiagramViewPrototype) {
            String diagramName;
            PapyrusRepresentationKind representation = prototype.getRepresentationKind();
            Assert.isTrue((boolean)(representation instanceof SiriusDiagramPrototype), (String)"The representation associated to the PapyrusDSemanticDiagramViewPrototype must be an instanceof SiriusDiagramPrototype.");
            SiriusDiagramPrototype docProto = (SiriusDiagramPrototype)representation;
            String string = diagramName = name == null || name.isEmpty() ? this.askName(prototype, semanticContext) : name;
            if (diagramName == null) {
                return null;
            }
            if (semanticContext instanceof NamedElement && !(semanticContext instanceof Activity)) {
                final NamedElement namedElement = (NamedElement)semanticContext;
                final Activity activity = UMLFactory.eINSTANCE.createActivity();
                ElementDefaultNameProvider elementDefaultNameProvider = new ElementDefaultNameProvider();
                activity.setName(elementDefaultNameProvider.getDefaultName((NamedElement)activity, semanticContext));
                try {
                    ServicesRegistry serviceRegistry = ServiceUtilsForResourceSet.getInstance().getServiceRegistry(namedElement.eResource().getResourceSet());
                    TransactionalEditingDomain ted = (TransactionalEditingDomain)serviceRegistry.getService(TransactionalEditingDomain.class);
                    if (namedElement instanceof Package) {
                        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                            protected void doExecute() {
                                ((Package)namedElement).getPackagedElements().add((Object)activity);
                            }
                        });
                    } else if (namedElement instanceof BehavioredClassifier) {
                        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                            protected void doExecute() {
                                ((BehavioredClassifier)namedElement).getOwnedBehaviors().add((Object)activity);
                                ((BehavioredClassifier)namedElement).setClassifierBehavior((Behavior)activity);
                            }
                        });
                    }
                    return super.execute(docProto, diagramName, (EObject)activity, (EObject)activity, openAfterCreation, docProto.getImplementationID());
                }
                catch (ServiceException e) {
                    Activator.log.error("Unexpected Error", (Throwable)e);
                }
            }
            return super.execute(docProto, diagramName, graphicalContext, semanticContext, openAfterCreation, docProto.getImplementationID());
        }
        return null;
    }
}

