/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTreeRowHideShowCategoryHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class TreeRowHideAllCategoriesHandler
extends AbstractTreeRowHideShowCategoryHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command cmd;
        int maxDepth = FillingConfigurationUtils.getMaxDepthForTree(this.getTable());
        Table table = this.getTable();
        ArrayList<Integer> toHide = new ArrayList<Integer>();
        int start = 0;
        if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), 0)) {
            start = 1;
        }
        int i = start;
        while (i <= maxDepth) {
            toHide.add(i);
            ++i;
        }
        IntListValueStyle values = StyleUtils.getHiddenDepthsValueStyle(table);
        if (values == null) {
            values = NattablestyleFactory.eINSTANCE.createIntListValueStyle();
            values.setName("hiddenCategoriesByDepth");
            values.eSet((EStructuralFeature)NattablestylePackage.eINSTANCE.getIntListValueStyle_IntListValue(), toHide);
            cmd = AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)table, (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), Collections.singleton(values));
        } else {
            toHide.removeAll((Collection<?>)values.getIntListValue());
            if (toHide.isEmpty()) {
                return null;
            }
            cmd = AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)values, (Object)NattablestylePackage.eINSTANCE.getIntListValueStyle_IntListValue(), toHide);
        }
        this.getTableEditingDomain().getCommandStack().execute(cmd);
        return null;
    }

    @Override
    protected boolean computeEnable(Object evaluationContext) {
        boolean calculatedValue = super.computeEnable(evaluationContext);
        if (calculatedValue) {
            calculatedValue = this.allCategoriesAreCurrentlyHidden();
        }
        return calculatedValue;
    }
}

