/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IComponentModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ICloseablePart;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.editor.welcome.IWelcomePageService;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomePage;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomePageService;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorDescriptor;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.IPluggableEditorFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class WelcomePageFactory
implements IPluggableEditorFactory {
    private ServicesRegistry services;
    private ImageDescriptor icon;

    public void init(ServicesRegistry serviceRegistry, EditorDescriptor editorDescriptor) {
        this.services = serviceRegistry;
        this.icon = editorDescriptor.getIcon();
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new WelcomePageModel(pageIdentifier);
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        return WelcomePageService.isModel(pageIdentifier);
    }

    private class WelcomePageModel
    implements IComponentModel,
    IAdaptable {
        private Object model;
        private Image iconImage;
        private WelcomePage welcome;

        WelcomePageModel(Object model) {
            this.model = model;
        }

        public <T> T getAdapter(Class<T> adapter) {
            Object result = null;
            if (adapter == ICloseablePart.class || adapter == WelcomePage.class) {
                result = adapter.cast(this.welcome);
            }
            if (result == null) {
                result = Platform.getAdapterManager().getAdapter((Object)this, adapter);
            }
            return (T)result;
        }

        public String getTabTitle() {
            return "Welcome";
        }

        public Image getTabIcon() {
            if (this.iconImage == null && WelcomePageFactory.this.icon != null) {
                this.iconImage = WelcomePageFactory.this.icon.createImage((Device)Display.getCurrent());
            }
            return this.iconImage;
        }

        public Object getRawModel() {
            return this.model;
        }

        public void dispose() {
            if (this.iconImage != null) {
                this.iconImage.dispose();
                this.iconImage = null;
            }
        }

        public Composite createPartControl(Composite parent) {
            Composite result = null;
            try {
                IWelcomePageService service = (IWelcomePageService)WelcomePageFactory.this.services.getService(IWelcomePageService.class);
                this.welcome = new WelcomePage(service, this.model);
                result = this.welcome.createControl(parent);
            }
            catch (ServiceException e) {
                throw new IllegalStateException("Welcome-page service not available", e);
            }
            return result;
        }
    }
}

