/**
 * Copyright (c) 2007-2012, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers
 */
package xpt.diagram.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import xpt.Common;
import xpt.diagram.Utils_qvto;
import xpt.diagram.editpolicies.BaseItemSemanticEditPolicy;

@Singleton
@SuppressWarnings("all")
public class CreateLinkUtils {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private BaseItemSemanticEditPolicy xptBaseItemSemanticEditPolicy;

  /**
   * Check whether link may be created.
   */
  public CharSequence canCreate(final LinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean canExecute() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (source == null && target == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (source != null && ");
    CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getSourceType(), "source");
    _builder.append(_NotInstance, "\t\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (target != null && ");
    CharSequence _NotInstance_1 = this.xptMetaModel.NotInstance(it.getTargetType(), "target");
    _builder.append(_NotInstance_1, "\t\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (getSource() == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return true; // link creation is in progress; source is not defined yet");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// target may be null here but it\'s possible to check constraint");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _canCreateElement = this.canCreateElement(it, link);
    _builder.append(_canCreateElement, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _canCreateElement(final LinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _canCreateElement(final TypeLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        _builder.append("if (getContainer() == null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _canCreateCall = this.xptBaseItemSemanticEditPolicy.canCreateCall(it, link, "getContainer()", "getSource()", "getTarget()");
    _builder.append(_canCreateCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _canCreateElement(final FeatureLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return ");
    CharSequence _canCreateCall = this.xptBaseItemSemanticEditPolicy.canCreateCall(it, link, "getSource()", "getTarget()");
    _builder.append(_canCreateCall);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * Fields of command that creates link.
   */
  protected CharSequence _fields(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected final org.eclipse.emf.ecore.EObject source;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected final org.eclipse.emf.ecore.EObject target;");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _fields(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected final org.eclipse.emf.ecore.EObject source;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected final org.eclipse.emf.ecore.EObject target;");
    _builder.newLine();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("protected ");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getContainmentMetaFeature().getGenClass());
        _builder.append(_QualifiedClassName);
        _builder.append(" container;");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  /**
   * Field accessors of command that creates link.
   */
  public CharSequence accessors(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getSourceType());
    _builder.append(_QualifiedClassName);
    _builder.append(" getSource() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(it.getSourceType(), "source");
    _builder.append(_CastEObject, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getTargetType());
    _builder.append(_QualifiedClassName_1);
    _builder.append(" getTarget() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _CastEObject_1 = this.xptMetaModel.CastEObject(it.getTargetType(), "target");
    _builder.append(_CastEObject_1, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    CharSequence _containerAccessor = this.containerAccessor(it);
    _builder.append(_containerAccessor);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _containerAccessor(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _containerAccessor(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment, "\t");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getContainmentMetaFeature().getGenClass());
        _builder.append(_QualifiedClassName, "\t");
        _builder.append(" getContainer() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return container;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment(
          ("Default approach is to traverse ancestors of the source to find instance of container.\n" + "Modify with appropriate logic."));
        _builder.append(_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected ");
        CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getContainmentMetaFeature().getGenClass());
        _builder.append(_QualifiedClassName_1, "\t");
        _builder.append(" deduceContainer(org.eclipse.emf.ecore.EObject source, org.eclipse.emf.ecore.EObject target) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("// Find container element for the new link.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Climb up by containment hierarchy starting from the source");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// and return the first element that is instance of the container class.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (org.eclipse.emf.ecore.EObject element = source; element != null; element = element.eContainer()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (");
        CharSequence _IsInstance = this.xptMetaModel.IsInstance(it.getContainmentMetaFeature().getGenClass(), "element");
        _builder.append(_IsInstance, "\t\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("return ");
        CharSequence _CastEObject = this.xptMetaModel.CastEObject(it.getContainmentMetaFeature().getGenClass(), "element");
        _builder.append(_CastEObject, "\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    return _builder;
  }

  /**
   * Part of the constructor that performs initialization.
   */
  protected CharSequence _initAndDeduceContainerIfNeeded(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.source = source;");
    _builder.newLine();
    _builder.append("this.target = target;");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _initAndDeduceContainerIfNeeded(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.source = source;");
    _builder.newLine();
    _builder.append("this.target = target;");
    _builder.newLine();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        _builder.append("container = deduceContainer(source, target);");
        _builder.newLine();
      }
    }
    return _builder;
  }

  @XbaseGenerated
  public CharSequence canCreateElement(final LinkModelFacet it, final GenLink link) {
    if (it instanceof FeatureLinkModelFacet) {
      return _canCreateElement((FeatureLinkModelFacet)it, link);
    } else if (it instanceof TypeLinkModelFacet) {
      return _canCreateElement((TypeLinkModelFacet)it, link);
    } else if (it != null) {
      return _canCreateElement(it, link);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, link).toString());
    }
  }

  @XbaseGenerated
  public CharSequence fields(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _fields((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _fields(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence containerAccessor(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _containerAccessor((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _containerAccessor(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence initAndDeduceContainerIfNeeded(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _initAndDeduceContainerIfNeeded((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _initAndDeduceContainerIfNeeded(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
