/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.emf.readonly.handlers;

import com.google.common.base.Optional;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FSReadOnlyHandler
extends AbstractReadOnlyHandler {
    public FSReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
        Optional<Boolean> result;
        if (!axes.contains(ReadOnlyAxis.PERMISSION)) {
            result = Optional.absent();
        } else {
            AbstractReadOnlyHandler.ResourceReadOnlyCache cache = this.getResourceCache();
            if (cache != null) {
                result = Optional.absent();
                int i = 0;
                while (i < uris.length) {
                    URI uri = uris[i];
                    result = cache.get(axes, uri);
                    if (result == null) {
                        result = this.computeAnyReadOnly(new URI[]{uri});
                        cache.put(ReadOnlyAxis.permissionAxes(), uri, result);
                    }
                    if (!((Boolean)result.or((Object)Boolean.FALSE)).booleanValue()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                result = this.computeAnyReadOnly(uris);
            }
        }
        return result;
    }

    protected Optional<Boolean> computeAnyReadOnly(URI[] uris) {
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            URI uri = uRIArray[n2];
            IFile ifile = FSReadOnlyHandler.getIFile(uri);
            if (ifile != null ? ifile.isReadOnly() : (file = FSReadOnlyHandler.getFile(uri)) != null && file.exists() && !file.canWrite()) {
                return Optional.of((Object)Boolean.TRUE);
            }
            ++n2;
        }
        return Optional.absent();
    }

    private static IFile getIFile(URI uri) {
        if (uri.isPlatform()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }

    private static File getFile(URI uri) {
        if (uri.isFile()) {
            return new File(uri.toFileString());
        }
        return null;
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        if (!axes.contains(ReadOnlyAxis.PERMISSION)) {
            return Optional.absent();
        }
        final AtomicBoolean doEnableWrite = new AtomicBoolean();
        final LinkedHashMap<IFile, URI> readOnlyFiles = new LinkedHashMap<IFile, URI>();
        int i = 0;
        while (i < uris.length) {
            IFile file = FSReadOnlyHandler.getIFile(uris[i]);
            if (file != null && file.isReadOnly()) {
                readOnlyFiles.put(file, uris[i]);
            }
            ++i;
        }
        if (!readOnlyFiles.isEmpty()) {
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    Object message = "Do you want to remove read only flag on those files ?\n\n";
                    for (IFile file : readOnlyFiles.keySet()) {
                        message = (String)message + file.getName() + "\n";
                    }
                    doEnableWrite.set(MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Enable Write", (String)message));
                }
            });
        }
        if (doEnableWrite.get()) {
            Boolean ok = true;
            for (Map.Entry next : readOnlyFiles.entrySet()) {
                try {
                    IFile file = (IFile)next.getKey();
                    ResourceAttributes att = file.getResourceAttributes();
                    att.setReadOnly(false);
                    file.setResourceAttributes(att);
                    this.fireReadOnlyStateChanged(ReadOnlyAxis.PERMISSION, (URI)next.getValue(), true);
                }
                catch (CoreException e) {
                    ok = false;
                }
            }
            return Optional.of((Object)ok);
        }
        return Optional.absent();
    }

    public Optional<Boolean> canMakeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        Optional result = Optional.absent();
        if (axes.contains(ReadOnlyAxis.PERMISSION)) {
            int i = 0;
            while ((!result.isPresent() || ((Boolean)result.get()).booleanValue()) && i < uris.length) {
                if (uris[i].isPlatformResource()) {
                    result = Optional.of((Object)true);
                } else if (uris[i].isFile()) {
                    result = Optional.of((Object)false);
                }
                ++i;
            }
        }
        return result;
    }
}

