/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.common.utils;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public final class ContainerUtil {
    private ContainerUtil() {
    }

    public static void addToContainer(EObject container, EStructuralFeature eStructuralFeature, Object value) {
        Objects.requireNonNull(container);
        Objects.requireNonNull(eStructuralFeature);
        if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)eStructuralFeature)) {
            List list = (List)container.eGet(eStructuralFeature);
            list.add(value);
        } else {
            container.eSet(eStructuralFeature, value);
        }
    }

    public static List<EClass> getSubclassesOf(EClass type, boolean concreteClassesOnly) {
        Objects.requireNonNull(type);
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        if (!concreteClassesOnly || !type.isAbstract() && !type.isInterface()) {
            result.add(type);
        }
        EPackage ePackage = ContainerUtil.getRootPackage(type.getEPackage());
        ContainerUtil.getSubclassesOf(type, ePackage, result, concreteClassesOnly);
        return new LinkedList<EClass>(result.stream().sorted(Comparator.comparing(ENamedElement::getName)).collect(Collectors.toList()));
    }

    private static void getSubclassesOf(EClass type, EPackage fromPackage, Set<EClass> result, boolean concreteClassesOnly) {
        for (EClassifier classifier : fromPackage.getEClassifiers()) {
            EClass eClass;
            if (!(classifier instanceof EClass) || !(eClass = (EClass)classifier).getEAllSuperTypes().contains((Object)type) || concreteClassesOnly && (eClass.isAbstract() || eClass.isInterface())) continue;
            result.add(eClass);
        }
        for (EPackage subPackage : fromPackage.getESubpackages()) {
            ContainerUtil.getSubclassesOf(type, subPackage, result, concreteClassesOnly);
        }
    }

    private static EPackage getRootPackage(EPackage ePackage) {
        EPackage result = null;
        if (ePackage != null) {
            result = ePackage.getESuperPackage() == null ? ePackage : ContainerUtil.getRootPackage(ePackage.getESuperPackage());
        }
        return result;
    }
}

