/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.matrix.validator;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.nattable.manager.table.IMatrixTableWidgetManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.GenericRelationshipMatrixCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.EObjectWrapper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.ui.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.uml.nattable.matrix.Activator;
import org.eclipse.papyrus.uml.nattable.matrix.messages.Messages;

public class RelationshipOwnerValidator
implements IValidator {
    private final GenericRelationshipMatrixCellEditorConfiguration conf;

    public RelationshipOwnerValidator(IMatrixTableWidgetManager matrixManager) {
        this.conf = (GenericRelationshipMatrixCellEditorConfiguration)matrixManager.getTable().getOwnedCellEditorConfigurations();
    }

    private final IStatus createErrorStatus(String message) {
        return new Status(4, "org.eclipse.papyrus.uml.nattable.matrix", message);
    }

    public IStatus validate(Object value) {
        EObject realEObject = null;
        if (value instanceof EObjectWrapper) {
            realEObject = ((EObjectWrapper)value).getElement();
        } else if (value instanceof EObjectTreeItemAxis) {
            realEObject = ((EObjectTreeItemAxis)value).getElement();
        } else if (value instanceof EObject) {
            realEObject = (EObject)value;
        }
        if (realEObject == null) {
            return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_ElementCantBeResolvedAsEObject, (Object)value));
        }
        IStatus relationshipDefinition = this.hasADefinedRelationship();
        if (!relationshipDefinition.isOK()) {
            return relationshipDefinition;
        }
        boolean hasAValidFeature = this.hasFeatureAcceptingRelationShip(realEObject);
        if (!hasAValidFeature) {
            ILabelProvider labelProvider = this.getLabelProvider(realEObject);
            String realObjectLabel = labelProvider != null ? labelProvider.getText((Object)realEObject) : realEObject.toString();
            switch (this.conf.getRelationshipOwnerStrategy()) {
                case COLUMN_AS_OWNER: {
                    return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_ColumnCantbeUsedAsOwner, (Object)realObjectLabel));
                }
                case COLUMN_OWNER: {
                    return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_ColumnOwnerCantbeUsedAsOwner, (Object)realObjectLabel));
                }
                case DEFAULT: {
                    return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_ItIsAPapyrusBug, (Object)realObjectLabel));
                }
                case OTHER: {
                    return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_TheChosenElementCantBeUsedAsOwner, (Object)realObjectLabel));
                }
                case ROW_AS_OWNER: {
                    return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_RowCantbeUsedAsOwner, (Object)realObjectLabel));
                }
                case ROW_OWNER: {
                    return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_RowOwnerCantbeUsedAsOwner, (Object)realObjectLabel));
                }
                case TABLE_CONTEXT: {
                    return this.createErrorStatus(NLS.bind((String)Messages.RelationshipOwnerValidator_TableContextCantbeUsedAsOwner, (Object)realObjectLabel));
                }
            }
        }
        return Status.OK_STATUS;
    }

    private final IStatus hasADefinedRelationship() {
        ElementTypeConfiguration etc = this.conf.getEditedElement();
        if (etc == null) {
            return this.createErrorStatus(Messages.RelationshipOwnerValidator_NoRelationshipDefined);
        }
        EClass eclass = this.getBaseMetamodelEClass(etc);
        if (eclass != null && eclass.isAbstract()) {
            return this.createErrorStatus(Messages.RelationshipOwnerValidator_ChosenRelationshipIsAbstract);
        }
        return Status.OK_STATUS;
    }

    private final boolean hasFeatureAcceptingRelationShip(EObject wantedOwner) {
        Assert.isNotNull((Object)wantedOwner);
        ElementTypeConfiguration etc = this.conf.getEditedElement();
        EClass eclass = this.getBaseMetamodelEClass(etc);
        if (eclass != null) {
            EObject dummyRelationship = eclass.getEPackage().getEFactoryInstance().create(eclass);
            for (EStructuralFeature current : wantedOwner.eClass().getEAllContainments()) {
                if (!current.getEType().isInstance((Object)dummyRelationship)) continue;
                return true;
            }
        }
        return false;
    }

    private EClass getBaseMetamodelEClass(ElementTypeConfiguration elementTypeConfiguration) {
        return this.getBaseMetamodelTypeConfiguration(elementTypeConfiguration) != null ? this.getBaseMetamodelTypeConfiguration(elementTypeConfiguration).getEClass() : null;
    }

    private MetamodelTypeConfiguration getBaseMetamodelTypeConfiguration(ElementTypeConfiguration elementTypeConfiguration) {
        if (elementTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return (MetamodelTypeConfiguration)elementTypeConfiguration;
        }
        if (elementTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this.getBaseMetamodelTypeConfiguration((SpecializationTypeConfiguration)elementTypeConfiguration);
        }
        return null;
    }

    private MetamodelTypeConfiguration getBaseMetamodelTypeConfiguration(SpecializationTypeConfiguration elementTypeConfiguration) {
        return 1 == elementTypeConfiguration.getSpecializedTypes().size() ? this.getBaseMetamodelTypeConfiguration((ElementTypeConfiguration)elementTypeConfiguration.getSpecializedTypes().get(0)) : null;
    }

    private final ILabelProvider getLabelProvider(EObject eobject) {
        LabelProviderService lpSvc = null;
        try {
            lpSvc = eobject.eResource() != null ? (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)eobject) : (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)NestedEditingDialogContext.getInstance().getResourceSet());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (lpSvc != null) {
            return lpSvc.getLabelProvider();
        }
        return null;
    }
}

