/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimatableScrollPane;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.OverlayScrollPaneLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class LinkLFShapeCompartmentEditPart
extends ShapeCompartmentEditPart {
    private PropertyChangeListener myGridListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("SnapToGrid.GridOrigin".equals(propertyName) || "SnapToGrid.isEnabled".equals(propertyName) || "SnapToGrid.GridSpacing".equals(propertyName)) {
                LinkLFShapeCompartmentEditPart.this.updateGridBehavior();
            }
        }
    };

    public LinkLFShapeCompartmentEditPart(View view) {
        super(view);
    }

    public IFigure createFigure() {
        ShapeCompartmentFigureEx result = new ShapeCompartmentFigureEx(this.getCompartmentName(), this.getMapMode());
        result.getContentPane().setLayoutManager(this.getLayoutManager());
        result.getContentPane().addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        return result;
    }

    public void addNotify() {
        super.addNotify();
        this.getViewer().addPropertyChangeListener(this.myGridListener);
        this.updateGridBehavior();
    }

    public void removeNotify() {
        this.getViewer().removePropertyChangeListener(this.myGridListener);
        this.unsetScrollGridBehaviour(this.getCompartmentFigure());
        super.removeNotify();
    }

    protected void updateGridBehavior() {
        Rectangle gridSpec = LinkLFShapeCompartmentEditPart.getGridSpec(this.getViewer());
        if (gridSpec != null) {
            this.setScrollGridBehaviour(this.getCompartmentFigure());
        }
    }

    protected void setScrollGridBehaviour(ResizableCompartmentFigure compartmentFigure) {
        ScrollPane sp = compartmentFigure.getScrollPane();
        this.decorateHorizontalRange(sp);
        this.decorateVerticalRange(sp);
        this.updateStepIncrements(sp);
    }

    private void unsetScrollGridBehaviour(ResizableCompartmentFigure compartmentFigure) {
        ScrollPane sp = compartmentFigure.getScrollPane();
        this.undecorateHorizontalRange(sp);
        this.undecorateVerticalRange(sp);
        this.updateStepIncrements(sp);
    }

    private void undecorateVerticalRange(ScrollPane pane) {
        pane.setViewport(null);
        pane.setVerticalScrollBar(null);
    }

    private void undecorateHorizontalRange(ScrollPane pane) {
        pane.setViewport(null);
        pane.setHorizontalScrollBar(null);
    }

    private void updateStepIncrements(ScrollPane pane) {
        Rectangle gridSpec = LinkLFShapeCompartmentEditPart.getGridSpec(this.getViewer());
        if (gridSpec == null) {
            return;
        }
        ScrollBar hScroll = pane.getHorizontalScrollBar();
        hScroll.setStepIncrement(gridSpec.height);
        ScrollBar wScroll = pane.getVerticalScrollBar();
        wScroll.setStepIncrement(gridSpec.width);
    }

    private void decorateVerticalRange(ScrollPane pane) {
        ScrollBar scroll = pane.getVerticalScrollBar();
        RangeModel model = scroll.getRangeModel();
        if (!(model instanceof SnapToGridRangeModel)) {
            SnapToGridRangeModel range = new SnapToGridRangeModel(model);
            scroll.setRangeModel((RangeModel)range);
            pane.getViewport().setVerticalRangeModel((RangeModel)range);
        }
    }

    private void decorateHorizontalRange(ScrollPane pane) {
        ScrollBar scroll = pane.getHorizontalScrollBar();
        RangeModel model = scroll.getRangeModel();
        if (!(model instanceof SnapToGridRangeModel)) {
            SnapToGridRangeModel range = new SnapToGridRangeModel(model);
            scroll.setRangeModel((RangeModel)range);
            pane.getViewport().setHorizontalRangeModel((RangeModel)range);
        }
    }

    protected static Rectangle getGridSpec(EditPartViewer viewer) {
        Point loc;
        Boolean enabled = (Boolean)viewer.getProperty("SnapToGrid.isEnabled");
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        int gridX = 0;
        int gridY = 0;
        Dimension spacing = (Dimension)viewer.getProperty("SnapToGrid.GridSpacing");
        if (spacing != null) {
            gridX = spacing.width;
            gridY = spacing.height;
        }
        if (gridX == 0) {
            gridX = 12;
        }
        if (gridY == 0) {
            gridY = 12;
        }
        Point origin = (loc = (Point)viewer.getProperty("SnapToGrid.GridOrigin")) != null ? loc : new Point();
        return new Rectangle(origin.x, origin.y, gridX, gridY);
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        return super.getTargetEditPart(request);
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {
            this.refreshBounds();
        }
        super.handleNotificationEvent(notification);
    }

    protected void refreshBounds() {
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension size = new Dimension(width, height);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBounds();
    }

    private static class AnimatableScrollPaneWithMM
    extends AnimatableScrollPane
    implements IMapMode {
        private IMapMode myMapMode;

        public AnimatableScrollPaneWithMM(IMapMode mm) {
            this.myMapMode = mm;
        }

        public int LPtoDP(int logicalUnit) {
            return this.myMapMode.LPtoDP(logicalUnit);
        }

        public int DPtoLP(int deviceUnit) {
            return this.myMapMode.DPtoLP(deviceUnit);
        }

        public Translatable LPtoDP(Translatable t) {
            return this.myMapMode.LPtoDP(t);
        }

        public Translatable DPtoLP(Translatable t) {
            return this.myMapMode.DPtoLP(t);
        }
    }

    public static class ShapeCompartmentFigureEx
    extends ShapeCompartmentFigure {
        public ShapeCompartmentFigureEx(String title, IMapMode mm) {
            super(title, mm);
        }

        protected void configureFigure(IMapMode mm) {
            Object scrollpane = this.getScrollPane();
            if (scrollpane == null) {
                scrollpane = this.scrollPane = new AnimatableScrollPaneWithMM(mm);
            }
            scrollpane.setViewport((Viewport)new FreeformViewport());
            this.scrollPane.setScrollBarVisibility(1);
            scrollpane.setLayoutManager((LayoutManager)new OverlayScrollPaneLayout());
            BorderItemsAwareFreeFormLayer contents = new BorderItemsAwareFreeFormLayer();
            contents.setLayoutManager((LayoutManager)new FreeFormLayoutEx());
            scrollpane.setContents((IFigure)contents);
            int MB = mm.DPtoLP(5);
            scrollpane.setBorder((Border)new MarginBorder(MB, MB, MB, MB));
            int SZ = mm.DPtoLP(10);
            scrollpane.setMinimumSize(new Dimension(SZ, SZ));
            this.setFont(FONT_TITLE);
        }
    }

    private class SnapToGridRangeModel
    implements RangeModel {
        private RangeModel myBaseRangeModel;

        public SnapToGridRangeModel(RangeModel rangeModel) {
            this.myBaseRangeModel = rangeModel;
        }

        public void setValue(int value) {
            Rectangle gridSpec = LinkLFShapeCompartmentEditPart.getGridSpec(LinkLFShapeCompartmentEditPart.this.getViewer());
            if (gridSpec != null) {
                value = Math.max(value, 0);
                value = gridSpec.height * (value / gridSpec.height);
            }
            if (value + this.getMinimum() <= this.getMaximum()) {
                this.myBaseRangeModel.setValue(value);
            }
        }

        public void setMinimum(int min) {
            this.myBaseRangeModel.setMinimum(min);
        }

        public void setMaximum(int max) {
            this.myBaseRangeModel.setMaximum(max);
        }

        public void setExtent(int extent) {
            this.myBaseRangeModel.setExtent(extent);
        }

        public void setAll(int min, int extent, int max) {
            this.myBaseRangeModel.setAll(min, extent, max);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.myBaseRangeModel.removePropertyChangeListener(listener);
        }

        public boolean isEnabled() {
            return true;
        }

        public int getValue() {
            return this.myBaseRangeModel.getValue();
        }

        public int getMinimum() {
            return this.myBaseRangeModel.getMinimum();
        }

        public int getMaximum() {
            return this.myBaseRangeModel.getMaximum();
        }

        public int getExtent() {
            return this.myBaseRangeModel.getExtent();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.myBaseRangeModel.addPropertyChangeListener(listener);
        }
    }
}

