/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.destroy;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.destroy.DestroyerStatus;
import org.eclipse.papyrus.uml.domain.services.destroy.IDestroyerChecker;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDestroyerChecker
implements IDestroyerChecker {
    private final IEditableChecker editableChecker;
    private final ECrossReferenceAdapter crossReferenceAdapter;

    public ElementDestroyerChecker(ECrossReferenceAdapter crossReferenceAdapter, IEditableChecker editableChecker) {
        this.editableChecker = editableChecker;
        this.crossReferenceAdapter = crossReferenceAdapter;
    }

    @Override
    public DestroyerStatus canDestroy(Set<EObject> objectsToDelete) {
        DestroyerStatus destroyerStatus = DestroyerStatus.createOKStatus(objectsToDelete);
        Stream<EObject> crossReferenceOwners = objectsToDelete.stream().flatMap(object -> this.crossReferenceAdapter.getInverseReferences(object).stream()).filter(setting -> !setting.getEStructuralFeature().isDerived()).map(setting -> setting.getEObject());
        Set notEditableObjects = Stream.concat(objectsToDelete.stream(), crossReferenceOwners).filter(object -> !this.editableChecker.canEdit((EObject)object)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!notEditableObjects.isEmpty()) {
            destroyerStatus = DestroyerStatus.createFailingStatus("One of the elements, impacted by the elements to delete, can not be edited", notEditableObjects);
        } else {
            DeletableElementCheckerSwitch destroyerCheckerSwitch = new DeletableElementCheckerSwitch(objectsToDelete);
            destroyerStatus = objectsToDelete.stream().map(object -> (DestroyerStatus)destroyerCheckerSwitch.doSwitch((EObject)object)).filter(object -> State.FAILED.equals((Object)object.getState())).findFirst().orElse(destroyerStatus);
        }
        return destroyerStatus;
    }

    class DeletableElementCheckerSwitch
    extends UMLSwitch<DestroyerStatus> {
        private Set<EObject> objectsToDelete;

        DeletableElementCheckerSwitch(Set<EObject> objectsToDelete) {
            this.objectsToDelete = objectsToDelete;
        }

        public DestroyerStatus caseRegion(Region region) {
            EList stateMachineRegions;
            DestroyerStatus destroyerStatus = DestroyerStatus.createOKStatus(Set.of(region));
            StateMachine stateMachine = region.getStateMachine();
            if (stateMachine != null && !this.objectsToDelete.contains(stateMachine) && (stateMachineRegions = region.getStateMachine().getRegions()).size() == 1 && stateMachineRegions.contains(region)) {
                destroyerStatus = DestroyerStatus.createFailingStatus("The region can not be delete because it is the last one of the StateMachine", Set.of(region));
            }
            return destroyerStatus;
        }

        public DestroyerStatus defaultCase(EObject object) {
            return DestroyerStatus.createOKStatus(Set.of(object));
        }
    }
}

