/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;
import org.eclipse.papyrus.uml.domain.services.properties.PropertiesCrudServices;
import org.eclipse.papyrus.uml.domain.services.properties.PropertiesUMLServices;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;

public class PropertiesValueSpecificationServices {
    private static final String VALUE_FEATURE_NAME = "value";
    private final PropertiesUMLServices propertiesUMLServices;
    private final PropertiesCrudServices propertiesCrudServices;

    public PropertiesValueSpecificationServices(ILogger logger, IEditableChecker checker) {
        this.propertiesUMLServices = new PropertiesUMLServices(logger);
        this.propertiesCrudServices = new PropertiesCrudServices(logger, checker);
    }

    public boolean setLiteralIntegerValue(LiteralInteger target, Object newValue) {
        if (this.checkIntegerValue(newValue)) {
            Integer integerToSet = null;
            if (newValue instanceof Integer) {
                integerToSet = (Integer)newValue;
            } else if (newValue instanceof String) {
                integerToSet = this.propertiesUMLServices.convertStringToInteger(newValue);
            }
            return this.propertiesCrudServices.set((EObject)target, VALUE_FEATURE_NAME, integerToSet);
        }
        return false;
    }

    public boolean setLiteralRealValue(LiteralReal target, Object newValue) {
        if (this.checkRealValue(newValue)) {
            Double realToSet = null;
            if (newValue instanceof Double) {
                realToSet = (Double)newValue;
            } else if (newValue instanceof String) {
                realToSet = this.propertiesUMLServices.convertStringToReal(newValue);
            }
            return this.propertiesCrudServices.set((EObject)target, VALUE_FEATURE_NAME, realToSet);
        }
        return false;
    }

    public boolean setLiteralUnlimitedNaturalValue(LiteralUnlimitedNatural target, Object newValue) {
        if (this.checkUnlimitedNaturalValue(newValue)) {
            Integer unlimitedNaturalToSet = null;
            if (newValue instanceof Integer) {
                unlimitedNaturalToSet = (Integer)newValue;
            } else if (newValue instanceof String) {
                unlimitedNaturalToSet = this.propertiesUMLServices.convertStringToIUnlimitedNatural(newValue);
            }
            return this.propertiesCrudServices.set((EObject)target, VALUE_FEATURE_NAME, unlimitedNaturalToSet);
        }
        return false;
    }

    public String getLiteralIntegerValue(LiteralInteger target) {
        return Integer.toString(target.getValue());
    }

    public String getLiteralRealValue(LiteralReal target) {
        return Double.toString(target.getValue());
    }

    public String getLiteralUnlimitedNaturalValue(LiteralUnlimitedNatural target) {
        return this.propertiesUMLServices.convertUnlimitedNaturalToString(target.getValue());
    }

    public boolean validateLiteralIntegerField(EObject target) {
        EStructuralFeature featureValue = target.eClass().getEStructuralFeature(VALUE_FEATURE_NAME);
        return this.checkIntegerValue(target.eGet(featureValue));
    }

    public boolean validateLiteralRealField(EObject target) {
        EStructuralFeature featureValue = target.eClass().getEStructuralFeature(VALUE_FEATURE_NAME);
        return this.checkRealValue(target.eGet(featureValue));
    }

    public boolean validateLiteralUnlimitedNaturalField(EObject target) {
        EStructuralFeature featureValue = target.eClass().getEStructuralFeature(VALUE_FEATURE_NAME);
        return this.checkUnlimitedNaturalValue(target.eGet(featureValue));
    }

    private boolean checkIntegerValue(Object value) {
        boolean result = false;
        if (value instanceof Integer) {
            result = true;
        } else {
            try {
                Integer integerValue = this.propertiesUMLServices.convertStringToInteger(value);
                result = integerValue != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }

    private boolean checkRealValue(Object value) {
        boolean result = false;
        if (value instanceof Double) {
            result = true;
        } else {
            try {
                Double real = this.propertiesUMLServices.convertStringToReal(value);
                result = real != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }

    private boolean checkUnlimitedNaturalValue(Object value) {
        boolean result = false;
        if (value instanceof Integer) {
            result = true;
        } else if (value instanceof String) {
            if ("*".equals(value)) {
                result = true;
            } else {
                try {
                    result = this.propertiesUMLServices.convertStringToIUnlimitedNatural(value) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return result;
    }
}

