/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceUrlHandler;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class MarketplaceDropAdapter
implements IStartup {
    public void earlyStartup() {
        UIJob registerJob = new UIJob(Display.getDefault(), Messages.MarketplaceDropAdapter_0){
            {
                this.setPriority(50);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow[] workbenchWindows;
                IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = workbenchWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    Shell shell = window.getShell();
                    MarketplaceDropAdapter.this.installDropTarget(shell);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        registerJob.schedule();
    }

    public void installDropTarget(Shell shell) {
        int operations = 7;
        DropTarget target = new DropTarget((Control)shell, operations);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent e) {
                if (e.detail == 0) {
                    e.detail = 4;
                }
            }

            public void dragOperationChanged(DropTargetEvent e) {
                if (e.detail == 0) {
                    e.detail = 4;
                }
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                String url = this.getUrlFromEvent(event);
                if (MarketplaceUrlHandler.isPotentialSolution(url)) {
                    MarketplaceDropAdapter.this.proceedInstallation(url);
                }
            }

            private String getUrlFromEvent(DropTargetEvent event) {
                String eventData = (String)event.data;
                String[] dataLines = eventData.split(System.getProperty("line.separator"));
                String url = dataLines[0];
                return url;
            }
        });
    }

    protected void proceedInstallation(String url) {
        MarketplaceUrlHandler.SolutionInstallationInfo info = MarketplaceUrlHandler.createSolutionInstallInfo(url);
        if (info != null) {
            MarketplaceUrlHandler.triggerInstall(info);
        }
    }
}

