/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="ACP")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class AccessControlPolicyEntity
extends AnnounceableSubordinateEntity {
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="ACP_ACR_PVS", joinColumns={@JoinColumn(name="ACP_RI", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACR_ID", referencedColumnName="ACR_ID")})
    protected List<AccessControlRuleEntity> selfPrivileges;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="ACP_ACR_PV", joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACR_ID", referencedColumnName="ACR_ID")})
    protected List<AccessControlRuleEntity> privileges;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSEB_CHILDACP", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCse;
    @ManyToOne
    @JoinTable(name="AE_CHACP", inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected AeEntity parentAE;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_ACPCH_JOIN", inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCsr;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, targetEntity=SubscriptionEntity.class)
    @JoinTable(name="ACP_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> childSubscriptions;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSEB_ACP", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<CSEBaseEntity> linkedCses;
    @ManyToMany
    @JoinTable(name="AE_ACP", inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AeEntity> linkedAes;
    @ManyToMany
    @JoinTable(name="CNT_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<ContainerEntity> linkedCnts;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, targetEntity=SubscriptionEntity.class)
    @JoinTable(name="SUB_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> linkedSubscription;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=PollingChannelEntity.class)
    @JoinTable(name="ACP_PCH_JOIN", inverseJoinColumns={@JoinColumn(name="PCH_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<PollingChannelEntity> linkedPch;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=NodeEntity.class)
    @JoinTable(name="NOD_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<PollingChannelEntity> linkedNod;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=AreaNwkInfoEntity.class)
    @JoinTable(name="ANI_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AreaNwkInfoEntity> areaNwkInfoEntities;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=AreaNwkDeviceInfoEntity.class)
    @JoinTable(name="ANDI_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AreaNwkDeviceInfoEntity> areaNwkDeviceInfoEntities;

    public List<AccessControlRuleEntity> getPrivileges() {
        if (this.privileges == null) {
            this.privileges = new ArrayList<AccessControlRuleEntity>();
        }
        return this.privileges;
    }

    public void setPrivileges(List<AccessControlRuleEntity> privileges) {
        this.privileges = privileges;
    }

    public List<AccessControlRuleEntity> getSelfPrivileges() {
        if (this.selfPrivileges == null) {
            this.selfPrivileges = new ArrayList<AccessControlRuleEntity>();
        }
        return this.selfPrivileges;
    }

    public void setSelfPrivileges(List<AccessControlRuleEntity> selfPrivileges) {
        this.selfPrivileges = selfPrivileges;
    }

    public CSEBaseEntity getParentCse() {
        return this.parentCse;
    }

    public void setParentCse(CSEBaseEntity parentCse) {
        this.parentCse = parentCse;
    }

    public AeEntity getParentAE() {
        return this.parentAE;
    }

    public void setParentAE(AeEntity parentAE) {
        this.parentAE = parentAE;
    }

    public RemoteCSEEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(RemoteCSEEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public List<CSEBaseEntity> getLinkedCse() {
        if (this.linkedCses == null) {
            this.linkedCses = new ArrayList<CSEBaseEntity>();
        }
        return this.linkedCses;
    }

    public void setLinkedCse(List<CSEBaseEntity> linkedCse) {
        this.linkedCses = linkedCse;
    }

    public List<ContainerEntity> getLinkedContainers() {
        if (this.linkedCnts == null) {
            this.linkedCnts = new ArrayList<ContainerEntity>();
        }
        return this.linkedCnts;
    }

    public void setLinkedContainer(List<ContainerEntity> linkedContainer) {
        this.linkedCnts = linkedContainer;
    }

    public List<SubscriptionEntity> getLinkedSubscription() {
        if (this.linkedSubscription == null) {
            this.linkedSubscription = new ArrayList<SubscriptionEntity>();
        }
        return this.linkedSubscription;
    }

    public void setLinkedSubscription(List<SubscriptionEntity> linkedSubscription) {
        this.linkedSubscription = linkedSubscription;
    }

    public List<PollingChannelEntity> getLinkedPch() {
        if (this.linkedPch == null) {
            this.linkedPch = new ArrayList<PollingChannelEntity>();
        }
        return this.linkedPch;
    }

    public void setLinkedPch(List<PollingChannelEntity> linkedPch) {
        this.linkedPch = linkedPch;
    }

    public List<AeEntity> getLinkedAes() {
        if (this.linkedAes == null) {
            this.linkedAes = new ArrayList<AeEntity>();
        }
        return this.linkedAes;
    }

    public void setLinkedAes(List<AeEntity> linkedAes) {
        this.linkedAes = linkedAes;
    }

    public List<SubscriptionEntity> getChildSubscriptions() {
        if (this.childSubscriptions == null) {
            this.childSubscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.childSubscriptions;
    }

    public void setChildSubscriptions(List<SubscriptionEntity> childSubscription) {
        this.childSubscriptions = childSubscription;
    }

    public List<PollingChannelEntity> getLinkedNod() {
        if (this.linkedNod == null) {
            this.linkedNod = new ArrayList<PollingChannelEntity>();
        }
        return this.linkedNod;
    }

    public void setLinkedNod(List<PollingChannelEntity> linkedNod) {
        this.linkedNod = linkedNod;
    }

    public List<AreaNwkInfoEntity> getAreaNwkInfoEntities() {
        if (this.areaNwkInfoEntities == null) {
            this.areaNwkInfoEntities = new ArrayList<AreaNwkInfoEntity>();
        }
        return this.areaNwkInfoEntities;
    }

    public void setAreaNwkInfoEntities(List<AreaNwkInfoEntity> areaNwkInfoEntities) {
        this.areaNwkInfoEntities = areaNwkInfoEntities;
    }

    public List<AreaNwkDeviceInfoEntity> getAreaNwkDeviceInfoEntities() {
        if (this.areaNwkDeviceInfoEntities == null) {
            this.areaNwkDeviceInfoEntities = new ArrayList<AreaNwkDeviceInfoEntity>();
        }
        return this.areaNwkDeviceInfoEntities;
    }

    public void setAreaNwkDeviceInfoEntities(List<AreaNwkDeviceInfoEntity> areaNwkDeviceInfoEntities) {
        this.areaNwkDeviceInfoEntities = areaNwkDeviceInfoEntities;
    }
}

