/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="ani")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class AreaNwkInfoEntity
extends MgmtObjEntity {
    @Column(name="ant")
    protected String areaNwkType;
    @Column(name="ldv")
    protected List<String> listOfDevices;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=AccessControlPolicyEntity.class)
    @JoinTable(name="ANI_ACP_JOIN", joinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> acps;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SubscriptionEntity.class)
    @JoinTable(name="ANI_SUB_JOIN", joinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=NodeEntity.class)
    @JoinTable(name="ANI_NOD_JOIN", joinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected NodeEntity parentNode;

    public AreaNwkInfoEntity() {
        this.mgmtDefinition = MgmtDefinitionTypes.AREA_NWK_INFO;
    }

    public String getAreaNwkType() {
        return this.areaNwkType;
    }

    public void setAreaNwkType(String areaNwkType) {
        this.areaNwkType = areaNwkType;
    }

    public List<String> getListOfDevices() {
        return this.listOfDevices;
    }

    public void setListOfDevices(List<String> listOfDevices) {
        this.listOfDevices = listOfDevices;
    }

    public List<AccessControlPolicyEntity> getAcps() {
        if (this.acps == null) {
            this.acps = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.acps;
    }

    public void setAcps(List<AccessControlPolicyEntity> acps) {
        this.acps = acps;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }
}

