/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.resource.AreaNwkDeviceInfo;
import org.eclipse.om2m.commons.resource.AreaNwkInfo;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.core.entitymapper.AreaNwkDeviceInfoMapper;
import org.eclipse.om2m.core.entitymapper.AreaNwkInfoMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;

public class NodeMapper
extends EntityMapper<NodeEntity, Node> {
    @Override
    protected void mapAttributes(NodeEntity entity, Node resource) {
        resource.setNodeID(entity.getNodeID());
        resource.setHostedCSELink(entity.getHostedCSELink());
        resource.setExpirationTime(entity.getExpirationTime());
        if (!entity.getAnnouncedAttribute().isEmpty()) {
            resource.getAnnouncedAttribute().addAll(entity.getAnnouncedAttribute());
        }
        if (!entity.getAnnounceTo().isEmpty()) {
            resource.getAnnounceTo().addAll(entity.getAnnounceTo());
        }
        for (AccessControlPolicyEntity acp : entity.getAccessControlPolicies()) {
            resource.getAccessControlPolicyIDs().add(acp.getResourceID());
        }
    }

    @Override
    protected void mapChildResourceRef(NodeEntity entity, Node resource) {
        ChildResourceRef chref;
        for (AreaNwkInfoEntity aniEntity : entity.getChildAreaNwkInfoEntities()) {
            chref = new ChildResourceRef();
            chref.setResourceName(aniEntity.getName());
            chref.setType(13);
            chref.setValue(aniEntity.getResourceID());
            resource.getChildResource().add(chref);
        }
        for (AreaNwkDeviceInfoEntity andiEntity : entity.getChildAreaNwkDeviceInfoEntities()) {
            chref = new ChildResourceRef();
            chref.setResourceName(andiEntity.getName());
            chref.setType(13);
            chref.setValue(andiEntity.getResourceID());
            resource.getChildResource().add(chref);
        }
    }

    @Override
    protected void mapChildResources(NodeEntity entity, Node resource) {
        for (AreaNwkInfoEntity aniEntity : entity.getChildAreaNwkInfoEntities()) {
            AreaNwkInfo aniRes = (AreaNwkInfo)new AreaNwkInfoMapper().mapEntityToResource(aniEntity, ResultContent.ATTRIBUTES);
            resource.getMemoryOrBatteryOrAreaNwkInfo().add(aniRes);
        }
        for (AreaNwkDeviceInfoEntity andiEntity : entity.getChildAreaNwkDeviceInfoEntities()) {
            AreaNwkDeviceInfo andiRes = (AreaNwkDeviceInfo)new AreaNwkDeviceInfoMapper().mapEntityToResource(andiEntity, ResultContent.ATTRIBUTES);
            resource.getMemoryOrBatteryOrAreaNwkInfo().add(andiRes);
        }
    }

    @Override
    protected Node createResource() {
        return new Node();
    }
}

