/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.OperationNotAllowed;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class ContentInstanceController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        List acpsToCheck = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 3) {
            ContainerEntity container = (ContainerEntity)parentEntity;
            acpsToCheck = container.getAccessControlPolicies();
            subscriptions = container.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 10003) {
            throw new NotImplementedException("Parent is Container Annc, not implemented yet.");
        }
        this.checkACP(acpsToCheck, request.getFrom(), request.getOperation());
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for ContentInstance creation");
        }
        ContentInstance cin = null;
        try {
            cin = request.getRequestContentType().equals("application/obj") ? (ContentInstance)request.getContent() : (ContentInstance)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (cin == null) {
            throw new BadRequestException("Error in provided content");
        }
        ContentInstanceEntity cinEntity = new ContentInstanceEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)cin, (ResourceEntity)cinEntity);
        if (!cin.getAnnouncedAttribute().isEmpty()) {
            cinEntity.getAnnouncedAttribute().addAll(cin.getAnnouncedAttribute());
        }
        if (cin.getContentInfo() == null) {
            cinEntity.setContentInfo("text/plain:0");
        } else {
            cinEntity.setContentInfo(cin.getContentInfo());
        }
        if (cin.getContent() == null) {
            throw new BadRequestException("Content is Mandatory");
        }
        String generatedId = ContentInstanceController.generateId("", "");
        cinEntity.setResourceID("/" + Constants.CSE_ID + "/" + "cin" + Constants.PREFIX_SEPERATOR + generatedId);
        if (cin.getName() != null) {
            if (!Patterns.checkResourceName(cin.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~]|\\.)+");
            }
            cinEntity.setName(cin.getName());
        } else if (request.getName() != null) {
            if (!Patterns.checkResourceName(request.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~]|\\.)+");
            }
            cinEntity.setName(request.getName());
        } else {
            cinEntity.setName("cin_" + generatedId);
        }
        cinEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + cinEntity.getName());
        if (!UriMapper.addNewUri(cinEntity.getHierarchicalURI(), cinEntity.getResourceID(), 4)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        cinEntity.setParentID(parentEntity.getResourceID());
        cinEntity.setResourceType(4);
        cinEntity.setContent(cin.getContent());
        cinEntity.setStateTag(BigInteger.valueOf(0L));
        if (cin.getCreator() != null) {
            cinEntity.setCreator(cin.getCreator());
        }
        if (cin.getExpirationTime() != null) {
            cinEntity.setExpirationTime(cin.getExpirationTime());
        }
        if (!cin.getAnnounceTo().isEmpty()) {
            cinEntity.getAnnounceTo().addAll(cin.getAnnounceTo());
        }
        if (cin.getOntologyRef() != null) {
            cinEntity.setOntologyRef(cin.getOntologyRef());
        }
        if (parentEntity.getResourceType().intValue() == 3) {
            ContainerEntity container = (ContainerEntity)parentEntity;
            List cinList = container.getChildContentInstances();
            if (container.getMaxNrOfInstances() != null && cinList.size() == container.getMaxNrOfInstances().intValue()) {
                LOGGER.info((Object)("Deleting oldest content instance due to container size limit: " + ((ContentInstanceEntity)container.getChildContentInstances().get(0)).getHierarchicalURI()));
                this.dbs.getDAOFactory().getContentInstanceDAO().delete(this.transaction, (Object)((ContentInstanceEntity)container.getChildContentInstances().get(0)));
                this.transaction.commit();
                this.transaction.close();
                this.transaction = this.dbs.getDbTransaction();
                this.transaction.open();
                container = (ContainerEntity)dao.find(this.transaction, (Object)request.getTargetId());
            }
            cinEntity.setParentContainer(container);
            if (container.getStateTag() != null) {
                container.setStateTag(BigInteger.valueOf(container.getStateTag().intValue() + 1));
                this.dbs.getDAOFactory().getContainerDAO().update(this.transaction, (Object)container);
            }
        }
        parentEntity.getResourceType().intValue();
        this.dbs.getDAOFactory().getContentInstanceDAO().create(this.transaction, (Object)cinEntity);
        this.transaction.commit();
        Notifier.notify(subscriptions, (ResourceEntity)cinEntity, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)cinEntity);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        ContentInstanceEntity cinEntity = (ContentInstanceEntity)this.dbs.getDAOFactory().getContentInstanceDAO().find(this.transaction, (Object)request.getTargetId());
        if (cinEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        List acpList = cinEntity.getAcpListFromParent();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        ContentInstance cin = EntityMapperFactory.getContentInstanceMapper().mapEntityToResource(cinEntity, request);
        response.setContent((Object)cin);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        throw new OperationNotAllowed("Update on ContentInstance is not Allowed");
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        ContentInstanceEntity cin = (ContentInstanceEntity)dbs.getDAOFactory().getContentInstanceDAO().find(transaction, (Object)request.getTargetId());
        if (cin == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkACP(cin.getAcpListFromParent(), request.getFrom(), request.getOperation());
        UriMapper.deleteUri(cin.getHierarchicalURI());
        Notifier.notifyDeletion(null, (ResourceEntity)cin);
        dbs.getDAOFactory().getContentInstanceDAO().delete(transaction, (Object)cin);
        transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

