/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.router;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;

public class Patterns {
    private static final String ALL_SHORT_NAMES = "acp|ae|cnt|cin|csr|la|ol|grp|fopt|sub|pch|pcu|req|nod|ani|andi";
    private static final String NON_HIERARCHICAL_ID = "(" + Constants.PREFIX_SEPERATOR + "(\\b\\w+\\b)?)";
    public static final Pattern UNAUTHORIZED_NAMES = Pattern.compile("acp" + NON_HIERARCHICAL_ID + "?|" + "ae" + NON_HIERARCHICAL_ID + "?|" + "cnt" + NON_HIERARCHICAL_ID + "?|" + "cin" + NON_HIERARCHICAL_ID + "?|" + "csr" + NON_HIERARCHICAL_ID + "?|" + "la" + NON_HIERARCHICAL_ID + "?|" + "ol" + NON_HIERARCHICAL_ID + "?|" + "grp" + NON_HIERARCHICAL_ID + "?|" + "fopt" + NON_HIERARCHICAL_ID + "?|" + "sub" + NON_HIERARCHICAL_ID + "?|" + "pch" + "?|" + "pcu" + "?|" + "req" + "?|" + "nod" + "?");
    public static final String ID_STRING = "([A-Za-z0-9_\\-~]|\\.)+";
    public static final Pattern ID_PATTERN = Pattern.compile("([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern CSE_BASE_PATTERN = Pattern.compile("/" + Constants.CSE_ID);
    public static final Pattern ACP_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "acp" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern AE_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "(C|S)" + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern CONTAINER_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "cnt" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern CONTENTINSTANCE_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "cin" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern REMOTE_CSE_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "csr" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern GROUP_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "grp" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern SUBSCRIPTION_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "sub" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern POLLING_CHANNEL_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "pch" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern POLLING_CHANNEL_URI_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "pcu" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern REQUEST_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "req" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern NON_RETARGETING_PATTERN = Pattern.compile("/" + Constants.CSE_ID + "(/(" + "([A-Za-z0-9_\\-~]|\\.)+" + ")?)*");
    public static final String FANOUT_POINT_MATCH = "/fopt";
    public static final Pattern NODE_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "nod" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern AREA_NW_INFO_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "ani" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern AREA_NWK_DEVICE_INFO_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "/" + "andi" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+");
    public static final Pattern NON_HIERARCHICAL_PATTERN = Pattern.compile("(" + CSE_BASE_PATTERN + "/(" + "acp|ae|cnt|cin|csr|la|ol|grp|fopt|sub|pch|pcu|req|nod|ani|andi" + ")" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~]|\\.)+" + ")|(" + CSE_BASE_PATTERN + ")|" + AE_PATTERN.pattern());
    public static final Pattern HIERARCHICAL_PATTERN = Pattern.compile(CSE_BASE_PATTERN + "(/" + Constants.CSE_NAME + "(/" + ID_PATTERN + ")*)?");

    public static boolean match(Pattern pattern, String uri) {
        Matcher m = pattern.matcher(uri);
        return m.matches();
    }

    public static DAO<?> getDAO(String uri, DBService db) {
        if (Patterns.match(CSE_BASE_PATTERN, uri)) {
            return db.getDAOFactory().getCSEBaseDAO();
        }
        if (Patterns.match(ACP_PATTERN, uri)) {
            return db.getDAOFactory().getAccessControlPolicyDAO();
        }
        if (Patterns.match(AE_PATTERN, uri)) {
            return db.getDAOFactory().getAeDAO();
        }
        if (Patterns.match(CONTAINER_PATTERN, uri)) {
            return db.getDAOFactory().getContainerDAO();
        }
        if (Patterns.match(CONTENTINSTANCE_PATTERN, uri)) {
            return db.getDAOFactory().getContentInstanceDAO();
        }
        if (Patterns.match(REMOTE_CSE_PATTERN, uri)) {
            return db.getDAOFactory().getRemoteCSEDAO();
        }
        if (Patterns.match(GROUP_PATTERN, uri)) {
            return db.getDAOFactory().getGroupDAO();
        }
        if (Patterns.match(SUBSCRIPTION_PATTERN, uri)) {
            return db.getDAOFactory().getSubsciptionDAO();
        }
        if (Patterns.match(POLLING_CHANNEL_PATTERN, uri)) {
            return db.getDAOFactory().getPollingChannelDAO();
        }
        if (Patterns.match(REQUEST_PATTERN, uri)) {
            return db.getDAOFactory().getRequestEntityDAO();
        }
        if (Patterns.match(NODE_PATTERN, uri)) {
            return db.getDAOFactory().getNodeEntityDAO();
        }
        return null;
    }

    public static boolean checkResourceName(String resourceName) {
        return Patterns.match(ID_PATTERN, resourceName);
    }
}

