/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Boiling;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.KeepWarm;
import org.eclipse.om2m.sdt.home.modules.RunMode;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class Kettle
extends GenericDevice {
    private FaultDetection faultDetection;
    private RunMode runMode;
    private BinarySwitch boilingSwitch;
    private Temperature temperature;
    private KeepWarm keepWarm;

    public Kettle(String id, String serial, DeviceType type, Domain domain) {
        super(id, serial, DeviceType.deviceKettle, domain);
    }

    public Kettle(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceKettle, domain);
    }

    public void addModule(Module module) {
        if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof RunMode) {
            this.addModule((RunMode)module);
        } else if (module instanceof BinarySwitch) {
            this.addModule((BinarySwitch)module);
        } else if (module instanceof KeepWarm) {
            this.addModule((KeepWarm)module);
        } else if (module instanceof Temperature) {
            this.addModule((Temperature)module);
        } else if (module instanceof Boiling) {
            this.addModule((Boiling)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(FaultDetection mod) {
        this.faultDetection = mod;
        super.addModule((Module)this.faultDetection);
    }

    public void addModule(RunMode mod) {
        this.runMode = mod;
        super.addModule((Module)this.runMode);
    }

    public void addModule(BinarySwitch mod) {
        this.boilingSwitch = mod;
        super.addModule((Module)this.boilingSwitch);
    }

    public void addModule(Temperature mod) {
        this.temperature = mod;
        super.addModule((Module)this.temperature);
    }

    public void addModule(KeepWarm mod) {
        this.keepWarm = mod;
        super.addModule((Module)this.keepWarm);
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public KeepWarm getKeepWarm() {
        return this.keepWarm;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public BinarySwitch getBoilingSwitch() {
        return this.boilingSwitch;
    }
}

